/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesResponse;
import co.elastic.clients.elasticsearch.indices.update_aliases.IndicesUpdateAliasBulk;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UpdateAliasesRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final List<IndicesUpdateAliasBulk> actions;
    public static final JsonpDeserializer<UpdateAliasesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateAliasesRequest::setupUpdateAliasesRequestDeserializer, Builder::build);
    public static final Endpoint<UpdateAliasesRequest, UpdateAliasesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpdateAliasesRequest, UpdateAliasesResponse>(request -> "POST", request -> "/_aliases", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateAliasesResponse._DESERIALIZER);

    public UpdateAliasesRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.actions = ModelTypeHelper.unmodifiable(builder.actions);
    }

    public UpdateAliasesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public List<IndicesUpdateAliasBulk> actions() {
        return this.actions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.actions != null) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (IndicesUpdateAliasBulk item0 : this.actions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUpdateAliasesRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(IndicesUpdateAliasBulk._DESERIALIZER), "actions", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UpdateAliasesRequest> {
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private List<IndicesUpdateAliasBulk> actions;

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder actions(@Nullable List<IndicesUpdateAliasBulk> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(IndicesUpdateAliasBulk ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(IndicesUpdateAliasBulk value) {
            if (this.actions == null) {
                this.actions = new ArrayList<IndicesUpdateAliasBulk>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder actions(Function<IndicesUpdateAliasBulk.Builder, ObjectBuilder<IndicesUpdateAliasBulk>> fn) {
            return this.actions(fn.apply(new IndicesUpdateAliasBulk.Builder()).build());
        }

        public Builder addActions(Function<IndicesUpdateAliasBulk.Builder, ObjectBuilder<IndicesUpdateAliasBulk>> fn) {
            return this.addActions(fn.apply(new IndicesUpdateAliasBulk.Builder()).build());
        }

        @Override
        public UpdateAliasesRequest build() {
            return new UpdateAliasesRequest(this);
        }
    }
}

