/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.OverlappingIndexTemplate;
import co.elastic.clients.elasticsearch.indices.SimulateIndexTemplateResponse;
import co.elastic.clients.elasticsearch.indices.TemplateMapping;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SimulateIndexTemplateRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final List<String> indexPatterns;
    @Nullable
    private final List<String> composedOf;
    @Nullable
    private final List<OverlappingIndexTemplate> overlapping;
    @Nullable
    private final TemplateMapping template;
    public static final JsonpDeserializer<SimulateIndexTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateIndexTemplateRequest::setupSimulateIndexTemplateRequestDeserializer, Builder::build);
    public static final Endpoint<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse>(request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/_simulate_index");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SimulateIndexTemplateResponse._DESERIALIZER);

    public SimulateIndexTemplateRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.indexPatterns = ModelTypeHelper.unmodifiable(builder.indexPatterns);
        this.composedOf = ModelTypeHelper.unmodifiable(builder.composedOf);
        this.overlapping = ModelTypeHelper.unmodifiable(builder.overlapping);
        this.template = builder.template;
    }

    public SimulateIndexTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public List<OverlappingIndexTemplate> overlapping() {
        return this.overlapping;
    }

    @Nullable
    public TemplateMapping template() {
        return this.template;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexPatterns != null) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.composedOf != null) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.overlapping != null) {
            generator.writeKey("overlapping");
            generator.writeStartArray();
            for (OverlappingIndexTemplate overlappingIndexTemplate : this.overlapping) {
                overlappingIndexTemplate.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
    }

    protected static void setupSimulateIndexTemplateRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns", new String[0]);
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of", new String[0]);
        op.add(Builder::overlapping, JsonpDeserializer.arrayDeserializer(OverlappingIndexTemplate._DESERIALIZER), "overlapping", new String[0]);
        op.add(Builder::template, TemplateMapping._DESERIALIZER, "template", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SimulateIndexTemplateRequest> {
        private String name;
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private List<String> composedOf;
        @Nullable
        private List<OverlappingIndexTemplate> overlapping;
        @Nullable
        private TemplateMapping template;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder indexPatterns(@Nullable List<String> value) {
            this.indexPatterns = value;
            return this;
        }

        public Builder indexPatterns(String ... value) {
            this.indexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addIndexPatterns(String value) {
            if (this.indexPatterns == null) {
                this.indexPatterns = new ArrayList<String>();
            }
            this.indexPatterns.add(value);
            return this;
        }

        public Builder composedOf(@Nullable List<String> value) {
            this.composedOf = value;
            return this;
        }

        public Builder composedOf(String ... value) {
            this.composedOf = Arrays.asList(value);
            return this;
        }

        public Builder addComposedOf(String value) {
            if (this.composedOf == null) {
                this.composedOf = new ArrayList<String>();
            }
            this.composedOf.add(value);
            return this;
        }

        public Builder overlapping(@Nullable List<OverlappingIndexTemplate> value) {
            this.overlapping = value;
            return this;
        }

        public Builder overlapping(OverlappingIndexTemplate ... value) {
            this.overlapping = Arrays.asList(value);
            return this;
        }

        public Builder addOverlapping(OverlappingIndexTemplate value) {
            if (this.overlapping == null) {
                this.overlapping = new ArrayList<OverlappingIndexTemplate>();
            }
            this.overlapping.add(value);
            return this;
        }

        public Builder overlapping(Function<OverlappingIndexTemplate.Builder, ObjectBuilder<OverlappingIndexTemplate>> fn) {
            return this.overlapping(fn.apply(new OverlappingIndexTemplate.Builder()).build());
        }

        public Builder addOverlapping(Function<OverlappingIndexTemplate.Builder, ObjectBuilder<OverlappingIndexTemplate>> fn) {
            return this.addOverlapping(fn.apply(new OverlappingIndexTemplate.Builder()).build());
        }

        public Builder template(@Nullable TemplateMapping value) {
            this.template = value;
            return this;
        }

        public Builder template(Function<TemplateMapping.Builder, ObjectBuilder<TemplateMapping>> fn) {
            return this.template(fn.apply(new TemplateMapping.Builder()).build());
        }

        @Override
        public SimulateIndexTemplateRequest build() {
            return new SimulateIndexTemplateRequest(this);
        }
    }
}

