/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexSettingBlocks
implements JsonpSerializable {
    @Nullable
    private final Boolean readOnly;
    @Nullable
    private final Boolean readOnlyAllowDelete;
    @Nullable
    private final Boolean read;
    @Nullable
    private final Boolean write;
    @Nullable
    private final Boolean metadata;
    public static final JsonpDeserializer<IndexSettingBlocks> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingBlocks::setupIndexSettingBlocksDeserializer, Builder::build);

    public IndexSettingBlocks(Builder builder) {
        this.readOnly = builder.readOnly;
        this.readOnlyAllowDelete = builder.readOnlyAllowDelete;
        this.read = builder.read;
        this.write = builder.write;
        this.metadata = builder.metadata;
    }

    public IndexSettingBlocks(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean readOnly() {
        return this.readOnly;
    }

    @Nullable
    public Boolean readOnlyAllowDelete() {
        return this.readOnlyAllowDelete;
    }

    @Nullable
    public Boolean read() {
        return this.read;
    }

    @Nullable
    public Boolean write() {
        return this.write;
    }

    @Nullable
    public Boolean metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.readOnly != null) {
            generator.writeKey("read_only");
            generator.write(this.readOnly.booleanValue());
        }
        if (this.readOnlyAllowDelete != null) {
            generator.writeKey("read_only_allow_delete");
            generator.write(this.readOnlyAllowDelete.booleanValue());
        }
        if (this.read != null) {
            generator.writeKey("read");
            generator.write(this.read.booleanValue());
        }
        if (this.write != null) {
            generator.writeKey("write");
            generator.write(this.write.booleanValue());
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.write(this.metadata.booleanValue());
        }
    }

    protected static void setupIndexSettingBlocksDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::readOnly, JsonpDeserializer.booleanDeserializer(), "read_only", "index.blocks.read_only");
        op.add(Builder::readOnlyAllowDelete, JsonpDeserializer.booleanDeserializer(), "read_only_allow_delete", "index.blocks.read_only_allow_delete");
        op.add(Builder::read, JsonpDeserializer.booleanDeserializer(), "read", "index.blocks.read");
        op.add(Builder::write, JsonpDeserializer.booleanDeserializer(), "write", "index.blocks.write");
        op.add(Builder::metadata, JsonpDeserializer.booleanDeserializer(), "metadata", "index.blocks.metadata");
    }

    public static class Builder
    implements ObjectBuilder<IndexSettingBlocks> {
        @Nullable
        private Boolean readOnly;
        @Nullable
        private Boolean readOnlyAllowDelete;
        @Nullable
        private Boolean read;
        @Nullable
        private Boolean write;
        @Nullable
        private Boolean metadata;

        public Builder readOnly(@Nullable Boolean value) {
            this.readOnly = value;
            return this;
        }

        public Builder readOnlyAllowDelete(@Nullable Boolean value) {
            this.readOnlyAllowDelete = value;
            return this;
        }

        public Builder read(@Nullable Boolean value) {
            this.read = value;
            return this;
        }

        public Builder write(@Nullable Boolean value) {
            this.write = value;
            return this;
        }

        public Builder metadata(@Nullable Boolean value) {
            this.metadata = value;
            return this;
        }

        @Override
        public IndexSettingBlocks build() {
            return new IndexSettingBlocks(this);
        }
    }
}

