/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ExistsRequest
extends RequestBase {
    private final List<String> index;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeDefaults;
    @Nullable
    private final Boolean local;
    public static final Endpoint<ExistsRequest, BooleanResponse, ElasticsearchError> ENDPOINT = new BooleanEndpoint<ExistsRequest>(request -> "HEAD", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, (Function<ExistsRequest, Map<String, String>>)((Function<ExistsRequest, Map>)request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.includeDefaults != null) {
            params.put("include_defaults", String.valueOf(request.includeDefaults));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }), (Function<ExistsRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), false, null);

    public ExistsRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.flatSettings = builder.flatSettings;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeDefaults = builder.includeDefaults;
        this.local = builder.local;
    }

    public ExistsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    public static class Builder
    implements ObjectBuilder<ExistsRequest> {
        private List<String> index;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeDefaults;
        @Nullable
        private Boolean local;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder includeDefaults(@Nullable Boolean value) {
            this.includeDefaults = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Override
        public ExistsRequest build() {
            return new ExistsRequest(this);
        }
    }
}

