/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.indices.DiskUsageResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DiskUsageRequest
extends RequestBase {
    private final String index;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean flush;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final TimeUnit masterTimeout;
    @Nullable
    private final TimeUnit timeout;
    @Nullable
    private final Boolean runExpensiveTasks;
    @Nullable
    private final String waitForActiveShards;
    public static final Endpoint<DiskUsageRequest, DiskUsageResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DiskUsageRequest, DiskUsageResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_disk_usage");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.flush != null) {
            params.put("flush", String.valueOf(request.flush));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout.toString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout.toString());
        }
        if (request.runExpensiveTasks != null) {
            params.put("run_expensive_tasks", String.valueOf(request.runExpensiveTasks));
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DiskUsageResponse._DESERIALIZER);

    public DiskUsageRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.flush = builder.flush;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.runExpensiveTasks = builder.runExpensiveTasks;
        this.waitForActiveShards = builder.waitForActiveShards;
    }

    public DiskUsageRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean flush() {
        return this.flush;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public TimeUnit masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public TimeUnit timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean runExpensiveTasks() {
        return this.runExpensiveTasks;
    }

    @Nullable
    public String waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public static class Builder
    implements ObjectBuilder<DiskUsageRequest> {
        private String index;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean flush;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private TimeUnit masterTimeout;
        @Nullable
        private TimeUnit timeout;
        @Nullable
        private Boolean runExpensiveTasks;
        @Nullable
        private String waitForActiveShards;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder flush(@Nullable Boolean value) {
            this.flush = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder masterTimeout(@Nullable TimeUnit value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable TimeUnit value) {
            this.timeout = value;
            return this;
        }

        public Builder runExpensiveTasks(@Nullable Boolean value) {
            this.runExpensiveTasks = value;
            return this;
        }

        public Builder waitForActiveShards(@Nullable String value) {
            this.waitForActiveShards = value;
            return this;
        }

        @Override
        public DiskUsageRequest build() {
            return new DiskUsageRequest(this);
        }
    }
}

