/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.analysis.CharFilter;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.Tokenizer;
import co.elastic.clients.elasticsearch.indices.AnalyzeResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AnalyzeRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String analyzer;
    @Nullable
    private final List<String> attributes;
    @Nullable
    private final List<CharFilter> charFilter;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final String field;
    @Nullable
    private final List<TokenFilter> filter;
    @Nullable
    private final String normalizer;
    @Nullable
    private final List<String> text;
    @Nullable
    private final Tokenizer tokenizer;
    public static final JsonpDeserializer<AnalyzeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeRequest::setupAnalyzeRequestDeserializer, Builder::build);
    public static final Endpoint<AnalyzeRequest, AnalyzeResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<AnalyzeRequest, AnalyzeResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_analyze");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_analyze");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, AnalyzeResponse._DESERIALIZER);

    public AnalyzeRequest(Builder builder) {
        this.index = builder.index;
        this.analyzer = builder.analyzer;
        this.attributes = ModelTypeHelper.unmodifiable(builder.attributes);
        this.charFilter = ModelTypeHelper.unmodifiable(builder.charFilter);
        this.explain = builder.explain;
        this.field = builder.field;
        this.filter = ModelTypeHelper.unmodifiable(builder.filter);
        this.normalizer = builder.normalizer;
        this.text = ModelTypeHelper.unmodifiable(builder.text);
        this.tokenizer = builder.tokenizer;
    }

    public AnalyzeRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public List<String> attributes() {
        return this.attributes;
    }

    @Nullable
    public List<CharFilter> charFilter() {
        return this.charFilter;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public List<TokenFilter> filter() {
        return this.filter;
    }

    @Nullable
    public String normalizer() {
        return this.normalizer;
    }

    @Nullable
    public List<String> text() {
        return this.text;
    }

    @Nullable
    public Tokenizer tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.attributes != null) {
            generator.writeKey("attributes");
            generator.writeStartArray();
            for (String string : this.attributes) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.charFilter != null) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (CharFilter charFilter : this.charFilter) {
                charFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (TokenFilter tokenFilter : this.filter) {
                tokenFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.write(this.normalizer);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.writeStartArray();
            for (String string : this.text) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    protected static void setupAnalyzeRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::attributes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(CharFilter._DESERIALIZER), "char_filter", new String[0]);
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(TokenFilter._DESERIALIZER), "filter", new String[0]);
        op.add(Builder::normalizer, JsonpDeserializer.stringDeserializer(), "normalizer", new String[0]);
        op.add(Builder::text, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "text", new String[0]);
        op.add(Builder::tokenizer, Tokenizer._DESERIALIZER, "tokenizer", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnalyzeRequest> {
        @Nullable
        private String index;
        @Nullable
        private String analyzer;
        @Nullable
        private List<String> attributes;
        @Nullable
        private List<CharFilter> charFilter;
        @Nullable
        private Boolean explain;
        @Nullable
        private String field;
        @Nullable
        private List<TokenFilter> filter;
        @Nullable
        private String normalizer;
        @Nullable
        private List<String> text;
        @Nullable
        private Tokenizer tokenizer;

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder attributes(@Nullable List<String> value) {
            this.attributes = value;
            return this;
        }

        public Builder attributes(String ... value) {
            this.attributes = Arrays.asList(value);
            return this;
        }

        public Builder addAttributes(String value) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<String>();
            }
            this.attributes.add(value);
            return this;
        }

        public Builder charFilter(@Nullable List<CharFilter> value) {
            this.charFilter = value;
            return this;
        }

        public Builder charFilter(CharFilter ... value) {
            this.charFilter = Arrays.asList(value);
            return this;
        }

        public Builder addCharFilter(CharFilter value) {
            if (this.charFilter == null) {
                this.charFilter = new ArrayList<CharFilter>();
            }
            this.charFilter.add(value);
            return this;
        }

        public Builder charFilter(Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(fn.apply(new CharFilter.Builder()).build());
        }

        public Builder addCharFilter(Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.addCharFilter(fn.apply(new CharFilter.Builder()).build());
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder filter(@Nullable List<TokenFilter> value) {
            this.filter = value;
            return this;
        }

        public Builder filter(TokenFilter ... value) {
            this.filter = Arrays.asList(value);
            return this;
        }

        public Builder addFilter(TokenFilter value) {
            if (this.filter == null) {
                this.filter = new ArrayList<TokenFilter>();
            }
            this.filter.add(value);
            return this;
        }

        public Builder filter(Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(fn.apply(new TokenFilter.Builder()).build());
        }

        public Builder addFilter(Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.addFilter(fn.apply(new TokenFilter.Builder()).build());
        }

        public Builder normalizer(@Nullable String value) {
            this.normalizer = value;
            return this;
        }

        public Builder text(@Nullable List<String> value) {
            this.text = value;
            return this;
        }

        public Builder text(String ... value) {
            this.text = Arrays.asList(value);
            return this;
        }

        public Builder addText(String value) {
            if (this.text == null) {
                this.text = new ArrayList<String>();
            }
            this.text.add(value);
            return this;
        }

        public Builder tokenizer(@Nullable Tokenizer value) {
            this.tokenizer = value;
            return this;
        }

        public Builder tokenizer(Function<Tokenizer.Builder, ObjectBuilder<Tokenizer>> fn) {
            return this.tokenizer(fn.apply(new Tokenizer.Builder()).build());
        }

        @Override
        public AnalyzeRequest build() {
            return new AnalyzeRequest(this);
        }
    }
}

