/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.get_lifecycle;

import co.elastic.clients.elasticsearch.ilm.Policy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Lifecycle
implements JsonpSerializable {
    private final String modifiedDate;
    private final Policy policy;
    private final long version;
    public static final JsonpDeserializer<Lifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Lifecycle::setupLifecycleDeserializer, Builder::build);

    public Lifecycle(Builder builder) {
        this.modifiedDate = Objects.requireNonNull(builder.modifiedDate, "modified_date");
        this.policy = Objects.requireNonNull(builder.policy, "policy");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public Lifecycle(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String modifiedDate() {
        return this.modifiedDate;
    }

    public Policy policy() {
        return this.policy;
    }

    public long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("modified_date");
        generator.write(this.modifiedDate);
        generator.writeKey("policy");
        this.policy.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupLifecycleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::modifiedDate, JsonpDeserializer.stringDeserializer(), "modified_date", new String[0]);
        op.add(Builder::policy, Policy._DESERIALIZER, "policy", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Lifecycle> {
        private String modifiedDate;
        private Policy policy;
        private Long version;

        public Builder modifiedDate(String value) {
            this.modifiedDate = value;
            return this;
        }

        public Builder policy(Policy value) {
            this.policy = value;
            return this;
        }

        public Builder policy(Function<Policy.Builder, ObjectBuilder<Policy>> fn) {
            return this.policy(fn.apply(new Policy.Builder()).build());
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        public Lifecycle build() {
            return new Lifecycle(this);
        }
    }
}

