/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.explain_lifecycle;

import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainPhaseExecution;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class LifecycleExplainManaged
implements LifecycleExplainVariant,
JsonpSerializable {
    private final String action;
    private final String actionTimeMillis;
    private final String age;
    @Nullable
    private final String failedStep;
    @Nullable
    private final Integer failedStepRetryCount;
    private final String index;
    @Nullable
    private final Boolean isAutoRetryableError;
    private final String lifecycleDateMillis;
    private final String phase;
    private final String phaseTimeMillis;
    private final String policy;
    private final String step;
    @Nullable
    private final Map<String, JsonData> stepInfo;
    private final String stepTimeMillis;
    private final LifecycleExplainPhaseExecution phaseExecution;
    public static final JsonpDeserializer<LifecycleExplainManaged> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LifecycleExplainManaged::setupLifecycleExplainManagedDeserializer, Builder::build);

    public LifecycleExplainManaged(Builder builder) {
        this.action = Objects.requireNonNull(builder.action, "action");
        this.actionTimeMillis = Objects.requireNonNull(builder.actionTimeMillis, "action_time_millis");
        this.age = Objects.requireNonNull(builder.age, "age");
        this.failedStep = builder.failedStep;
        this.failedStepRetryCount = builder.failedStepRetryCount;
        this.index = Objects.requireNonNull(builder.index, "index");
        this.isAutoRetryableError = builder.isAutoRetryableError;
        this.lifecycleDateMillis = Objects.requireNonNull(builder.lifecycleDateMillis, "lifecycle_date_millis");
        this.phase = Objects.requireNonNull(builder.phase, "phase");
        this.phaseTimeMillis = Objects.requireNonNull(builder.phaseTimeMillis, "phase_time_millis");
        this.policy = Objects.requireNonNull(builder.policy, "policy");
        this.step = Objects.requireNonNull(builder.step, "step");
        this.stepInfo = ModelTypeHelper.unmodifiable(builder.stepInfo);
        this.stepTimeMillis = Objects.requireNonNull(builder.stepTimeMillis, "step_time_millis");
        this.phaseExecution = Objects.requireNonNull(builder.phaseExecution, "phase_execution");
    }

    public LifecycleExplainManaged(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "true";
    }

    public String action() {
        return this.action;
    }

    public String actionTimeMillis() {
        return this.actionTimeMillis;
    }

    public String age() {
        return this.age;
    }

    @Nullable
    public String failedStep() {
        return this.failedStep;
    }

    @Nullable
    public Integer failedStepRetryCount() {
        return this.failedStepRetryCount;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Boolean isAutoRetryableError() {
        return this.isAutoRetryableError;
    }

    public String lifecycleDateMillis() {
        return this.lifecycleDateMillis;
    }

    public String phase() {
        return this.phase;
    }

    public String phaseTimeMillis() {
        return this.phaseTimeMillis;
    }

    public String policy() {
        return this.policy;
    }

    public String step() {
        return this.step;
    }

    @Nullable
    public Map<String, JsonData> stepInfo() {
        return this.stepInfo;
    }

    public String stepTimeMillis() {
        return this.stepTimeMillis;
    }

    public LifecycleExplainPhaseExecution phaseExecution() {
        return this.phaseExecution;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("managed", "true");
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("action_time_millis");
        generator.write(this.actionTimeMillis);
        generator.writeKey("age");
        generator.write(this.age);
        if (this.failedStep != null) {
            generator.writeKey("failed_step");
            generator.write(this.failedStep);
        }
        if (this.failedStepRetryCount != null) {
            generator.writeKey("failed_step_retry_count");
            generator.write(this.failedStepRetryCount.intValue());
        }
        generator.writeKey("index");
        generator.write(this.index);
        if (this.isAutoRetryableError != null) {
            generator.writeKey("is_auto_retryable_error");
            generator.write(this.isAutoRetryableError.booleanValue());
        }
        generator.writeKey("lifecycle_date_millis");
        generator.write(this.lifecycleDateMillis);
        generator.writeKey("phase");
        generator.write(this.phase);
        generator.writeKey("phase_time_millis");
        generator.write(this.phaseTimeMillis);
        generator.writeKey("policy");
        generator.write(this.policy);
        generator.writeKey("step");
        generator.write(this.step);
        if (this.stepInfo != null) {
            generator.writeKey("step_info");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.stepInfo.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("step_time_millis");
        generator.write(this.stepTimeMillis);
        generator.writeKey("phase_execution");
        this.phaseExecution.serialize(generator, mapper);
    }

    protected static void setupLifecycleExplainManagedDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action", new String[0]);
        op.add(Builder::actionTimeMillis, JsonpDeserializer.stringDeserializer(), "action_time_millis", new String[0]);
        op.add(Builder::age, JsonpDeserializer.stringDeserializer(), "age", new String[0]);
        op.add(Builder::failedStep, JsonpDeserializer.stringDeserializer(), "failed_step", new String[0]);
        op.add(Builder::failedStepRetryCount, JsonpDeserializer.integerDeserializer(), "failed_step_retry_count", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::isAutoRetryableError, JsonpDeserializer.booleanDeserializer(), "is_auto_retryable_error", new String[0]);
        op.add(Builder::lifecycleDateMillis, JsonpDeserializer.stringDeserializer(), "lifecycle_date_millis", new String[0]);
        op.add(Builder::phase, JsonpDeserializer.stringDeserializer(), "phase", new String[0]);
        op.add(Builder::phaseTimeMillis, JsonpDeserializer.stringDeserializer(), "phase_time_millis", new String[0]);
        op.add(Builder::policy, JsonpDeserializer.stringDeserializer(), "policy", new String[0]);
        op.add(Builder::step, JsonpDeserializer.stringDeserializer(), "step", new String[0]);
        op.add(Builder::stepInfo, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "step_info", new String[0]);
        op.add(Builder::stepTimeMillis, JsonpDeserializer.stringDeserializer(), "step_time_millis", new String[0]);
        op.add(Builder::phaseExecution, LifecycleExplainPhaseExecution._DESERIALIZER, "phase_execution", new String[0]);
        op.ignore("managed");
    }

    public static class Builder
    implements ObjectBuilder<LifecycleExplainManaged> {
        private String action;
        private String actionTimeMillis;
        private String age;
        @Nullable
        private String failedStep;
        @Nullable
        private Integer failedStepRetryCount;
        private String index;
        @Nullable
        private Boolean isAutoRetryableError;
        private String lifecycleDateMillis;
        private String phase;
        private String phaseTimeMillis;
        private String policy;
        private String step;
        @Nullable
        private Map<String, JsonData> stepInfo;
        private String stepTimeMillis;
        private LifecycleExplainPhaseExecution phaseExecution;

        public Builder action(String value) {
            this.action = value;
            return this;
        }

        public Builder actionTimeMillis(String value) {
            this.actionTimeMillis = value;
            return this;
        }

        public Builder age(String value) {
            this.age = value;
            return this;
        }

        public Builder failedStep(@Nullable String value) {
            this.failedStep = value;
            return this;
        }

        public Builder failedStepRetryCount(@Nullable Integer value) {
            this.failedStepRetryCount = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder isAutoRetryableError(@Nullable Boolean value) {
            this.isAutoRetryableError = value;
            return this;
        }

        public Builder lifecycleDateMillis(String value) {
            this.lifecycleDateMillis = value;
            return this;
        }

        public Builder phase(String value) {
            this.phase = value;
            return this;
        }

        public Builder phaseTimeMillis(String value) {
            this.phaseTimeMillis = value;
            return this;
        }

        public Builder policy(String value) {
            this.policy = value;
            return this;
        }

        public Builder step(String value) {
            this.step = value;
            return this;
        }

        public Builder stepInfo(@Nullable Map<String, JsonData> value) {
            this.stepInfo = value;
            return this;
        }

        public Builder putStepInfo(String key, JsonData value) {
            if (this.stepInfo == null) {
                this.stepInfo = new HashMap<String, JsonData>();
            }
            this.stepInfo.put(key, value);
            return this;
        }

        public Builder stepTimeMillis(String value) {
            this.stepTimeMillis = value;
            return this;
        }

        public Builder phaseExecution(LifecycleExplainPhaseExecution value) {
            this.phaseExecution = value;
            return this;
        }

        public Builder phaseExecution(Function<LifecycleExplainPhaseExecution.Builder, ObjectBuilder<LifecycleExplainPhaseExecution>> fn) {
            return this.phaseExecution(fn.apply(new LifecycleExplainPhaseExecution.Builder()).build());
        }

        @Override
        public LifecycleExplainManaged build() {
            return new LifecycleExplainManaged(this);
        }
    }
}

