/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.features;

import co.elastic.clients.elasticsearch.features.Feature;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetFeaturesResponse
implements JsonpSerializable {
    private final List<Feature> features;
    public static final JsonpDeserializer<GetFeaturesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetFeaturesResponse::setupGetFeaturesResponseDeserializer, Builder::build);

    public GetFeaturesResponse(Builder builder) {
        this.features = ModelTypeHelper.unmodifiableNonNull(builder.features, "features");
    }

    public GetFeaturesResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Feature> features() {
        return this.features;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("features");
        generator.writeStartArray();
        for (Feature item0 : this.features) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetFeaturesResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::features, JsonpDeserializer.arrayDeserializer(Feature._DESERIALIZER), "features", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetFeaturesResponse> {
        private List<Feature> features;

        public Builder features(List<Feature> value) {
            this.features = value;
            return this;
        }

        public Builder features(Feature ... value) {
            this.features = Arrays.asList(value);
            return this;
        }

        public Builder addFeatures(Feature value) {
            if (this.features == null) {
                this.features = new ArrayList<Feature>();
            }
            this.features.add(value);
            return this;
        }

        public Builder features(Function<Feature.Builder, ObjectBuilder<Feature>> fn) {
            return this.features(fn.apply(new Feature.Builder()).build());
        }

        public Builder addFeatures(Function<Feature.Builder, ObjectBuilder<Feature>> fn) {
            return this.addFeatures(fn.apply(new Feature.Builder()).build());
        }

        @Override
        public GetFeaturesResponse build() {
            return new GetFeaturesResponse(this);
        }
    }
}

