/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ClusterNodeCount
implements JsonpSerializable {
    private final int coordinatingOnly;
    private final int data;
    private final int ingest;
    private final int master;
    private final int total;
    private final int votingOnly;
    private final int dataCold;
    @Nullable
    private final Integer dataFrozen;
    private final int dataContent;
    private final int dataWarm;
    private final int dataHot;
    private final int ml;
    private final int remoteClusterClient;
    private final int transform;
    public static final JsonpDeserializer<ClusterNodeCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodeCount::setupClusterNodeCountDeserializer, Builder::build);

    public ClusterNodeCount(Builder builder) {
        this.coordinatingOnly = Objects.requireNonNull(builder.coordinatingOnly, "coordinating_only");
        this.data = Objects.requireNonNull(builder.data, "data");
        this.ingest = Objects.requireNonNull(builder.ingest, "ingest");
        this.master = Objects.requireNonNull(builder.master, "master");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.votingOnly = Objects.requireNonNull(builder.votingOnly, "voting_only");
        this.dataCold = Objects.requireNonNull(builder.dataCold, "data_cold");
        this.dataFrozen = builder.dataFrozen;
        this.dataContent = Objects.requireNonNull(builder.dataContent, "data_content");
        this.dataWarm = Objects.requireNonNull(builder.dataWarm, "data_warm");
        this.dataHot = Objects.requireNonNull(builder.dataHot, "data_hot");
        this.ml = Objects.requireNonNull(builder.ml, "ml");
        this.remoteClusterClient = Objects.requireNonNull(builder.remoteClusterClient, "remote_cluster_client");
        this.transform = Objects.requireNonNull(builder.transform, "transform");
    }

    public ClusterNodeCount(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int coordinatingOnly() {
        return this.coordinatingOnly;
    }

    public int data() {
        return this.data;
    }

    public int ingest() {
        return this.ingest;
    }

    public int master() {
        return this.master;
    }

    public int total() {
        return this.total;
    }

    public int votingOnly() {
        return this.votingOnly;
    }

    public int dataCold() {
        return this.dataCold;
    }

    @Nullable
    public Integer dataFrozen() {
        return this.dataFrozen;
    }

    public int dataContent() {
        return this.dataContent;
    }

    public int dataWarm() {
        return this.dataWarm;
    }

    public int dataHot() {
        return this.dataHot;
    }

    public int ml() {
        return this.ml;
    }

    public int remoteClusterClient() {
        return this.remoteClusterClient;
    }

    public int transform() {
        return this.transform;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("coordinating_only");
        generator.write(this.coordinatingOnly);
        generator.writeKey("data");
        generator.write(this.data);
        generator.writeKey("ingest");
        generator.write(this.ingest);
        generator.writeKey("master");
        generator.write(this.master);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("voting_only");
        generator.write(this.votingOnly);
        generator.writeKey("data_cold");
        generator.write(this.dataCold);
        if (this.dataFrozen != null) {
            generator.writeKey("data_frozen");
            generator.write(this.dataFrozen.intValue());
        }
        generator.writeKey("data_content");
        generator.write(this.dataContent);
        generator.writeKey("data_warm");
        generator.write(this.dataWarm);
        generator.writeKey("data_hot");
        generator.write(this.dataHot);
        generator.writeKey("ml");
        generator.write(this.ml);
        generator.writeKey("remote_cluster_client");
        generator.write(this.remoteClusterClient);
        generator.writeKey("transform");
        generator.write(this.transform);
    }

    protected static void setupClusterNodeCountDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::coordinatingOnly, JsonpDeserializer.integerDeserializer(), "coordinating_only", new String[0]);
        op.add(Builder::data, JsonpDeserializer.integerDeserializer(), "data", new String[0]);
        op.add(Builder::ingest, JsonpDeserializer.integerDeserializer(), "ingest", new String[0]);
        op.add(Builder::master, JsonpDeserializer.integerDeserializer(), "master", new String[0]);
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total", new String[0]);
        op.add(Builder::votingOnly, JsonpDeserializer.integerDeserializer(), "voting_only", new String[0]);
        op.add(Builder::dataCold, JsonpDeserializer.integerDeserializer(), "data_cold", new String[0]);
        op.add(Builder::dataFrozen, JsonpDeserializer.integerDeserializer(), "data_frozen", new String[0]);
        op.add(Builder::dataContent, JsonpDeserializer.integerDeserializer(), "data_content", new String[0]);
        op.add(Builder::dataWarm, JsonpDeserializer.integerDeserializer(), "data_warm", new String[0]);
        op.add(Builder::dataHot, JsonpDeserializer.integerDeserializer(), "data_hot", new String[0]);
        op.add(Builder::ml, JsonpDeserializer.integerDeserializer(), "ml", new String[0]);
        op.add(Builder::remoteClusterClient, JsonpDeserializer.integerDeserializer(), "remote_cluster_client", new String[0]);
        op.add(Builder::transform, JsonpDeserializer.integerDeserializer(), "transform", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterNodeCount> {
        private Integer coordinatingOnly;
        private Integer data;
        private Integer ingest;
        private Integer master;
        private Integer total;
        private Integer votingOnly;
        private Integer dataCold;
        @Nullable
        private Integer dataFrozen;
        private Integer dataContent;
        private Integer dataWarm;
        private Integer dataHot;
        private Integer ml;
        private Integer remoteClusterClient;
        private Integer transform;

        public Builder coordinatingOnly(int value) {
            this.coordinatingOnly = value;
            return this;
        }

        public Builder data(int value) {
            this.data = value;
            return this;
        }

        public Builder ingest(int value) {
            this.ingest = value;
            return this;
        }

        public Builder master(int value) {
            this.master = value;
            return this;
        }

        public Builder total(int value) {
            this.total = value;
            return this;
        }

        public Builder votingOnly(int value) {
            this.votingOnly = value;
            return this;
        }

        public Builder dataCold(int value) {
            this.dataCold = value;
            return this;
        }

        public Builder dataFrozen(@Nullable Integer value) {
            this.dataFrozen = value;
            return this;
        }

        public Builder dataContent(int value) {
            this.dataContent = value;
            return this;
        }

        public Builder dataWarm(int value) {
            this.dataWarm = value;
            return this;
        }

        public Builder dataHot(int value) {
            this.dataHot = value;
            return this;
        }

        public Builder ml(int value) {
            this.ml = value;
            return this;
        }

        public Builder remoteClusterClient(int value) {
            this.remoteClusterClient = value;
            return this;
        }

        public Builder transform(int value) {
            this.transform = value;
            return this;
        }

        @Override
        public ClusterNodeCount build() {
            return new ClusterNodeCount(this);
        }
    }
}

