/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.ClusterProcessor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterIngest
implements JsonpSerializable {
    private final int numberOfPipelines;
    private final Map<String, ClusterProcessor> processorStats;
    public static final JsonpDeserializer<ClusterIngest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterIngest::setupClusterIngestDeserializer, Builder::build);

    public ClusterIngest(Builder builder) {
        this.numberOfPipelines = Objects.requireNonNull(builder.numberOfPipelines, "number_of_pipelines");
        this.processorStats = ModelTypeHelper.unmodifiableNonNull(builder.processorStats, "processor_stats");
    }

    public ClusterIngest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int numberOfPipelines() {
        return this.numberOfPipelines;
    }

    public Map<String, ClusterProcessor> processorStats() {
        return this.processorStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("number_of_pipelines");
        generator.write(this.numberOfPipelines);
        generator.writeKey("processor_stats");
        generator.writeStartObject();
        for (Map.Entry<String, ClusterProcessor> item0 : this.processorStats.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupClusterIngestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::numberOfPipelines, JsonpDeserializer.integerDeserializer(), "number_of_pipelines", new String[0]);
        op.add(Builder::processorStats, JsonpDeserializer.stringMapDeserializer(ClusterProcessor._DESERIALIZER), "processor_stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterIngest> {
        private Integer numberOfPipelines;
        private Map<String, ClusterProcessor> processorStats;

        public Builder numberOfPipelines(int value) {
            this.numberOfPipelines = value;
            return this;
        }

        public Builder processorStats(Map<String, ClusterProcessor> value) {
            this.processorStats = value;
            return this;
        }

        public Builder putProcessorStats(String key, ClusterProcessor value) {
            if (this.processorStats == null) {
                this.processorStats = new HashMap<String, ClusterProcessor>();
            }
            this.processorStats.put(key, value);
            return this;
        }

        public Builder processorStats(String key, Function<ClusterProcessor.Builder, ObjectBuilder<ClusterProcessor>> fn) {
            return this.processorStats(Collections.singletonMap(key, fn.apply(new ClusterProcessor.Builder()).build()));
        }

        public Builder putProcessorStats(String key, Function<ClusterProcessor.Builder, ObjectBuilder<ClusterProcessor>> fn) {
            return this.putProcessorStats(key, fn.apply(new ClusterProcessor.Builder()).build());
        }

        @Override
        public ClusterIngest build() {
            return new ClusterIngest(this);
        }
    }
}

