/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch._types.CompletionStats;
import co.elastic.clients.elasticsearch._types.DocStats;
import co.elastic.clients.elasticsearch._types.FielddataStats;
import co.elastic.clients.elasticsearch._types.QueryCacheStats;
import co.elastic.clients.elasticsearch._types.SegmentsStats;
import co.elastic.clients.elasticsearch._types.StoreStats;
import co.elastic.clients.elasticsearch.cluster.stats.CharFilterTypes;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterIndicesShards;
import co.elastic.clients.elasticsearch.cluster.stats.FieldTypesMappings;
import co.elastic.clients.elasticsearch.cluster.stats.IndicesVersions;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ClusterIndices
implements JsonpSerializable {
    private final CompletionStats completion;
    private final long count;
    private final DocStats docs;
    private final FielddataStats fielddata;
    private final QueryCacheStats queryCache;
    private final SegmentsStats segments;
    private final ClusterIndicesShards shards;
    private final StoreStats store;
    private final FieldTypesMappings mappings;
    private final CharFilterTypes analysis;
    @Nullable
    private final List<IndicesVersions> versions;
    public static final JsonpDeserializer<ClusterIndices> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterIndices::setupClusterIndicesDeserializer, Builder::build);

    public ClusterIndices(Builder builder) {
        this.completion = Objects.requireNonNull(builder.completion, "completion");
        this.count = Objects.requireNonNull(builder.count, "count");
        this.docs = Objects.requireNonNull(builder.docs, "docs");
        this.fielddata = Objects.requireNonNull(builder.fielddata, "fielddata");
        this.queryCache = Objects.requireNonNull(builder.queryCache, "query_cache");
        this.segments = Objects.requireNonNull(builder.segments, "segments");
        this.shards = Objects.requireNonNull(builder.shards, "shards");
        this.store = Objects.requireNonNull(builder.store, "store");
        this.mappings = Objects.requireNonNull(builder.mappings, "mappings");
        this.analysis = Objects.requireNonNull(builder.analysis, "analysis");
        this.versions = ModelTypeHelper.unmodifiable(builder.versions);
    }

    public ClusterIndices(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public CompletionStats completion() {
        return this.completion;
    }

    public long count() {
        return this.count;
    }

    public DocStats docs() {
        return this.docs;
    }

    public FielddataStats fielddata() {
        return this.fielddata;
    }

    public QueryCacheStats queryCache() {
        return this.queryCache;
    }

    public SegmentsStats segments() {
        return this.segments;
    }

    public ClusterIndicesShards shards() {
        return this.shards;
    }

    public StoreStats store() {
        return this.store;
    }

    public FieldTypesMappings mappings() {
        return this.mappings;
    }

    public CharFilterTypes analysis() {
        return this.analysis;
    }

    @Nullable
    public List<IndicesVersions> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("completion");
        this.completion.serialize(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("docs");
        this.docs.serialize(generator, mapper);
        generator.writeKey("fielddata");
        this.fielddata.serialize(generator, mapper);
        generator.writeKey("query_cache");
        this.queryCache.serialize(generator, mapper);
        generator.writeKey("segments");
        this.segments.serialize(generator, mapper);
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("store");
        this.store.serialize(generator, mapper);
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.versions != null) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (IndicesVersions item0 : this.versions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupClusterIndicesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::completion, CompletionStats._DESERIALIZER, "completion", new String[0]);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::docs, DocStats._DESERIALIZER, "docs", new String[0]);
        op.add(Builder::fielddata, FielddataStats._DESERIALIZER, "fielddata", new String[0]);
        op.add(Builder::queryCache, QueryCacheStats._DESERIALIZER, "query_cache", new String[0]);
        op.add(Builder::segments, SegmentsStats._DESERIALIZER, "segments", new String[0]);
        op.add(Builder::shards, ClusterIndicesShards._DESERIALIZER, "shards", new String[0]);
        op.add(Builder::store, StoreStats._DESERIALIZER, "store", new String[0]);
        op.add(Builder::mappings, FieldTypesMappings._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::analysis, CharFilterTypes._DESERIALIZER, "analysis", new String[0]);
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(IndicesVersions._DESERIALIZER), "versions", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterIndices> {
        private CompletionStats completion;
        private Long count;
        private DocStats docs;
        private FielddataStats fielddata;
        private QueryCacheStats queryCache;
        private SegmentsStats segments;
        private ClusterIndicesShards shards;
        private StoreStats store;
        private FieldTypesMappings mappings;
        private CharFilterTypes analysis;
        @Nullable
        private List<IndicesVersions> versions;

        public Builder completion(CompletionStats value) {
            this.completion = value;
            return this;
        }

        public Builder completion(Function<CompletionStats.Builder, ObjectBuilder<CompletionStats>> fn) {
            return this.completion(fn.apply(new CompletionStats.Builder()).build());
        }

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder docs(DocStats value) {
            this.docs = value;
            return this;
        }

        public Builder docs(Function<DocStats.Builder, ObjectBuilder<DocStats>> fn) {
            return this.docs(fn.apply(new DocStats.Builder()).build());
        }

        public Builder fielddata(FielddataStats value) {
            this.fielddata = value;
            return this;
        }

        public Builder fielddata(Function<FielddataStats.Builder, ObjectBuilder<FielddataStats>> fn) {
            return this.fielddata(fn.apply(new FielddataStats.Builder()).build());
        }

        public Builder queryCache(QueryCacheStats value) {
            this.queryCache = value;
            return this;
        }

        public Builder queryCache(Function<QueryCacheStats.Builder, ObjectBuilder<QueryCacheStats>> fn) {
            return this.queryCache(fn.apply(new QueryCacheStats.Builder()).build());
        }

        public Builder segments(SegmentsStats value) {
            this.segments = value;
            return this;
        }

        public Builder segments(Function<SegmentsStats.Builder, ObjectBuilder<SegmentsStats>> fn) {
            return this.segments(fn.apply(new SegmentsStats.Builder()).build());
        }

        public Builder shards(ClusterIndicesShards value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ClusterIndicesShards.Builder, ObjectBuilder<ClusterIndicesShards>> fn) {
            return this.shards(fn.apply(new ClusterIndicesShards.Builder()).build());
        }

        public Builder store(StoreStats value) {
            this.store = value;
            return this;
        }

        public Builder store(Function<StoreStats.Builder, ObjectBuilder<StoreStats>> fn) {
            return this.store(fn.apply(new StoreStats.Builder()).build());
        }

        public Builder mappings(FieldTypesMappings value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<FieldTypesMappings.Builder, ObjectBuilder<FieldTypesMappings>> fn) {
            return this.mappings(fn.apply(new FieldTypesMappings.Builder()).build());
        }

        public Builder analysis(CharFilterTypes value) {
            this.analysis = value;
            return this;
        }

        public Builder analysis(Function<CharFilterTypes.Builder, ObjectBuilder<CharFilterTypes>> fn) {
            return this.analysis(fn.apply(new CharFilterTypes.Builder()).build());
        }

        public Builder versions(@Nullable List<IndicesVersions> value) {
            this.versions = value;
            return this;
        }

        public Builder versions(IndicesVersions ... value) {
            this.versions = Arrays.asList(value);
            return this;
        }

        public Builder addVersions(IndicesVersions value) {
            if (this.versions == null) {
                this.versions = new ArrayList<IndicesVersions>();
            }
            this.versions.add(value);
            return this;
        }

        public Builder versions(Function<IndicesVersions.Builder, ObjectBuilder<IndicesVersions>> fn) {
            return this.versions(fn.apply(new IndicesVersions.Builder()).build());
        }

        public Builder addVersions(Function<IndicesVersions.Builder, ObjectBuilder<IndicesVersions>> fn) {
            return this.addVersions(fn.apply(new IndicesVersions.Builder()).build());
        }

        @Override
        public ClusterIndices build() {
            return new ClusterIndices(this);
        }
    }
}

