/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.FieldTypes;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class CharFilterTypes
implements JsonpSerializable {
    private final List<FieldTypes> charFilterTypes;
    private final List<FieldTypes> tokenizerTypes;
    private final List<FieldTypes> filterTypes;
    private final List<FieldTypes> analyzerTypes;
    private final List<FieldTypes> builtInCharFilters;
    private final List<FieldTypes> builtInTokenizers;
    private final List<FieldTypes> builtInFilters;
    private final List<FieldTypes> builtInAnalyzers;
    public static final JsonpDeserializer<CharFilterTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharFilterTypes::setupCharFilterTypesDeserializer, Builder::build);

    public CharFilterTypes(Builder builder) {
        this.charFilterTypes = ModelTypeHelper.unmodifiableNonNull(builder.charFilterTypes, "char_filter_types");
        this.tokenizerTypes = ModelTypeHelper.unmodifiableNonNull(builder.tokenizerTypes, "tokenizer_types");
        this.filterTypes = ModelTypeHelper.unmodifiableNonNull(builder.filterTypes, "filter_types");
        this.analyzerTypes = ModelTypeHelper.unmodifiableNonNull(builder.analyzerTypes, "analyzer_types");
        this.builtInCharFilters = ModelTypeHelper.unmodifiableNonNull(builder.builtInCharFilters, "built_in_char_filters");
        this.builtInTokenizers = ModelTypeHelper.unmodifiableNonNull(builder.builtInTokenizers, "built_in_tokenizers");
        this.builtInFilters = ModelTypeHelper.unmodifiableNonNull(builder.builtInFilters, "built_in_filters");
        this.builtInAnalyzers = ModelTypeHelper.unmodifiableNonNull(builder.builtInAnalyzers, "built_in_analyzers");
    }

    public CharFilterTypes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<FieldTypes> charFilterTypes() {
        return this.charFilterTypes;
    }

    public List<FieldTypes> tokenizerTypes() {
        return this.tokenizerTypes;
    }

    public List<FieldTypes> filterTypes() {
        return this.filterTypes;
    }

    public List<FieldTypes> analyzerTypes() {
        return this.analyzerTypes;
    }

    public List<FieldTypes> builtInCharFilters() {
        return this.builtInCharFilters;
    }

    public List<FieldTypes> builtInTokenizers() {
        return this.builtInTokenizers;
    }

    public List<FieldTypes> builtInFilters() {
        return this.builtInFilters;
    }

    public List<FieldTypes> builtInAnalyzers() {
        return this.builtInAnalyzers;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("char_filter_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.charFilterTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("tokenizer_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.tokenizerTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("filter_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.filterTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("analyzer_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.analyzerTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_char_filters");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInCharFilters) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_tokenizers");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInTokenizers) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_filters");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInFilters) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_analyzers");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInAnalyzers) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupCharFilterTypesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::charFilterTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "char_filter_types", new String[0]);
        op.add(Builder::tokenizerTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "tokenizer_types", new String[0]);
        op.add(Builder::filterTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "filter_types", new String[0]);
        op.add(Builder::analyzerTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "analyzer_types", new String[0]);
        op.add(Builder::builtInCharFilters, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_char_filters", new String[0]);
        op.add(Builder::builtInTokenizers, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_tokenizers", new String[0]);
        op.add(Builder::builtInFilters, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_filters", new String[0]);
        op.add(Builder::builtInAnalyzers, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_analyzers", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CharFilterTypes> {
        private List<FieldTypes> charFilterTypes;
        private List<FieldTypes> tokenizerTypes;
        private List<FieldTypes> filterTypes;
        private List<FieldTypes> analyzerTypes;
        private List<FieldTypes> builtInCharFilters;
        private List<FieldTypes> builtInTokenizers;
        private List<FieldTypes> builtInFilters;
        private List<FieldTypes> builtInAnalyzers;

        public Builder charFilterTypes(List<FieldTypes> value) {
            this.charFilterTypes = value;
            return this;
        }

        public Builder charFilterTypes(FieldTypes ... value) {
            this.charFilterTypes = Arrays.asList(value);
            return this;
        }

        public Builder addCharFilterTypes(FieldTypes value) {
            if (this.charFilterTypes == null) {
                this.charFilterTypes = new ArrayList<FieldTypes>();
            }
            this.charFilterTypes.add(value);
            return this;
        }

        public Builder charFilterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.charFilterTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addCharFilterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addCharFilterTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder tokenizerTypes(List<FieldTypes> value) {
            this.tokenizerTypes = value;
            return this;
        }

        public Builder tokenizerTypes(FieldTypes ... value) {
            this.tokenizerTypes = Arrays.asList(value);
            return this;
        }

        public Builder addTokenizerTypes(FieldTypes value) {
            if (this.tokenizerTypes == null) {
                this.tokenizerTypes = new ArrayList<FieldTypes>();
            }
            this.tokenizerTypes.add(value);
            return this;
        }

        public Builder tokenizerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.tokenizerTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addTokenizerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addTokenizerTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder filterTypes(List<FieldTypes> value) {
            this.filterTypes = value;
            return this;
        }

        public Builder filterTypes(FieldTypes ... value) {
            this.filterTypes = Arrays.asList(value);
            return this;
        }

        public Builder addFilterTypes(FieldTypes value) {
            if (this.filterTypes == null) {
                this.filterTypes = new ArrayList<FieldTypes>();
            }
            this.filterTypes.add(value);
            return this;
        }

        public Builder filterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.filterTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addFilterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addFilterTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder analyzerTypes(List<FieldTypes> value) {
            this.analyzerTypes = value;
            return this;
        }

        public Builder analyzerTypes(FieldTypes ... value) {
            this.analyzerTypes = Arrays.asList(value);
            return this;
        }

        public Builder addAnalyzerTypes(FieldTypes value) {
            if (this.analyzerTypes == null) {
                this.analyzerTypes = new ArrayList<FieldTypes>();
            }
            this.analyzerTypes.add(value);
            return this;
        }

        public Builder analyzerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.analyzerTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addAnalyzerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addAnalyzerTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder builtInCharFilters(List<FieldTypes> value) {
            this.builtInCharFilters = value;
            return this;
        }

        public Builder builtInCharFilters(FieldTypes ... value) {
            this.builtInCharFilters = Arrays.asList(value);
            return this;
        }

        public Builder addBuiltInCharFilters(FieldTypes value) {
            if (this.builtInCharFilters == null) {
                this.builtInCharFilters = new ArrayList<FieldTypes>();
            }
            this.builtInCharFilters.add(value);
            return this;
        }

        public Builder builtInCharFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInCharFilters(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addBuiltInCharFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addBuiltInCharFilters(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder builtInTokenizers(List<FieldTypes> value) {
            this.builtInTokenizers = value;
            return this;
        }

        public Builder builtInTokenizers(FieldTypes ... value) {
            this.builtInTokenizers = Arrays.asList(value);
            return this;
        }

        public Builder addBuiltInTokenizers(FieldTypes value) {
            if (this.builtInTokenizers == null) {
                this.builtInTokenizers = new ArrayList<FieldTypes>();
            }
            this.builtInTokenizers.add(value);
            return this;
        }

        public Builder builtInTokenizers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInTokenizers(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addBuiltInTokenizers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addBuiltInTokenizers(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder builtInFilters(List<FieldTypes> value) {
            this.builtInFilters = value;
            return this;
        }

        public Builder builtInFilters(FieldTypes ... value) {
            this.builtInFilters = Arrays.asList(value);
            return this;
        }

        public Builder addBuiltInFilters(FieldTypes value) {
            if (this.builtInFilters == null) {
                this.builtInFilters = new ArrayList<FieldTypes>();
            }
            this.builtInFilters.add(value);
            return this;
        }

        public Builder builtInFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInFilters(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addBuiltInFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addBuiltInFilters(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder builtInAnalyzers(List<FieldTypes> value) {
            this.builtInAnalyzers = value;
            return this;
        }

        public Builder builtInAnalyzers(FieldTypes ... value) {
            this.builtInAnalyzers = Arrays.asList(value);
            return this;
        }

        public Builder addBuiltInAnalyzers(FieldTypes value) {
            if (this.builtInAnalyzers == null) {
                this.builtInAnalyzers = new ArrayList<FieldTypes>();
            }
            this.builtInAnalyzers.add(value);
            return this;
        }

        public Builder builtInAnalyzers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInAnalyzers(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addBuiltInAnalyzers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addBuiltInAnalyzers(fn.apply(new FieldTypes.Builder()).build());
        }

        @Override
        public CharFilterTypes build() {
            return new CharFilterTypes(this);
        }
    }
}

