/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.PendingTasksResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class PendingTasksRequest
extends RequestBase {
    @Nullable
    private final Boolean local;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<PendingTasksRequest, PendingTasksResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PendingTasksRequest, PendingTasksResponse>(request -> "GET", request -> "/_cluster/pending_tasks", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, PendingTasksResponse._DESERIALIZER);

    public PendingTasksRequest(Builder builder) {
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
    }

    public PendingTasksRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<PendingTasksRequest> {
        @Nullable
        private Boolean local;
        @Nullable
        private String masterTimeout;

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public PendingTasksRequest build() {
            return new PendingTasksRequest(this);
        }
    }
}

