/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ExistsComponentTemplateRequest
extends RequestBase {
    private final List<String> name;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final Boolean local;
    public static final Endpoint<ExistsComponentTemplateRequest, BooleanResponse, ElasticsearchError> ENDPOINT = new BooleanEndpoint<ExistsComponentTemplateRequest>(request -> "HEAD", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_component_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, (Function<ExistsComponentTemplateRequest, Map<String, String>>)((Function<ExistsComponentTemplateRequest, Map>)request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }), (Function<ExistsComponentTemplateRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), false, null);

    public ExistsComponentTemplateRequest(Builder builder) {
        this.name = ModelTypeHelper.unmodifiableNonNull(builder.name, "name");
        this.masterTimeout = builder.masterTimeout;
        this.local = builder.local;
    }

    public ExistsComponentTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> name() {
        return this.name;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    public static class Builder
    implements ObjectBuilder<ExistsComponentTemplateRequest> {
        private List<String> name;
        @Nullable
        private String masterTimeout;
        @Nullable
        private Boolean local;

        public Builder name(List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Override
        public ExistsComponentTemplateRequest build() {
            return new ExistsComponentTemplateRequest(this);
        }
    }
}

