/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.stats;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.ccr.stats.AutoFollowedCluster;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AutoFollowStats
implements JsonpSerializable {
    private final List<AutoFollowedCluster> autoFollowedClusters;
    private final long numberOfFailedFollowIndices;
    private final long numberOfFailedRemoteClusterStateRequests;
    private final long numberOfSuccessfulFollowIndices;
    private final List<ErrorCause> recentAutoFollowErrors;
    public static final JsonpDeserializer<AutoFollowStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoFollowStats::setupAutoFollowStatsDeserializer, Builder::build);

    public AutoFollowStats(Builder builder) {
        this.autoFollowedClusters = ModelTypeHelper.unmodifiableNonNull(builder.autoFollowedClusters, "auto_followed_clusters");
        this.numberOfFailedFollowIndices = Objects.requireNonNull(builder.numberOfFailedFollowIndices, "number_of_failed_follow_indices");
        this.numberOfFailedRemoteClusterStateRequests = Objects.requireNonNull(builder.numberOfFailedRemoteClusterStateRequests, "number_of_failed_remote_cluster_state_requests");
        this.numberOfSuccessfulFollowIndices = Objects.requireNonNull(builder.numberOfSuccessfulFollowIndices, "number_of_successful_follow_indices");
        this.recentAutoFollowErrors = ModelTypeHelper.unmodifiableNonNull(builder.recentAutoFollowErrors, "recent_auto_follow_errors");
    }

    public AutoFollowStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<AutoFollowedCluster> autoFollowedClusters() {
        return this.autoFollowedClusters;
    }

    public long numberOfFailedFollowIndices() {
        return this.numberOfFailedFollowIndices;
    }

    public long numberOfFailedRemoteClusterStateRequests() {
        return this.numberOfFailedRemoteClusterStateRequests;
    }

    public long numberOfSuccessfulFollowIndices() {
        return this.numberOfSuccessfulFollowIndices;
    }

    public List<ErrorCause> recentAutoFollowErrors() {
        return this.recentAutoFollowErrors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("auto_followed_clusters");
        generator.writeStartArray();
        for (AutoFollowedCluster autoFollowedCluster : this.autoFollowedClusters) {
            autoFollowedCluster.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("number_of_failed_follow_indices");
        generator.write(this.numberOfFailedFollowIndices);
        generator.writeKey("number_of_failed_remote_cluster_state_requests");
        generator.write(this.numberOfFailedRemoteClusterStateRequests);
        generator.writeKey("number_of_successful_follow_indices");
        generator.write(this.numberOfSuccessfulFollowIndices);
        generator.writeKey("recent_auto_follow_errors");
        generator.writeStartArray();
        for (ErrorCause errorCause : this.recentAutoFollowErrors) {
            errorCause.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupAutoFollowStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::autoFollowedClusters, JsonpDeserializer.arrayDeserializer(AutoFollowedCluster._DESERIALIZER), "auto_followed_clusters", new String[0]);
        op.add(Builder::numberOfFailedFollowIndices, JsonpDeserializer.longDeserializer(), "number_of_failed_follow_indices", new String[0]);
        op.add(Builder::numberOfFailedRemoteClusterStateRequests, JsonpDeserializer.longDeserializer(), "number_of_failed_remote_cluster_state_requests", new String[0]);
        op.add(Builder::numberOfSuccessfulFollowIndices, JsonpDeserializer.longDeserializer(), "number_of_successful_follow_indices", new String[0]);
        op.add(Builder::recentAutoFollowErrors, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "recent_auto_follow_errors", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AutoFollowStats> {
        private List<AutoFollowedCluster> autoFollowedClusters;
        private Long numberOfFailedFollowIndices;
        private Long numberOfFailedRemoteClusterStateRequests;
        private Long numberOfSuccessfulFollowIndices;
        private List<ErrorCause> recentAutoFollowErrors;

        public Builder autoFollowedClusters(List<AutoFollowedCluster> value) {
            this.autoFollowedClusters = value;
            return this;
        }

        public Builder autoFollowedClusters(AutoFollowedCluster ... value) {
            this.autoFollowedClusters = Arrays.asList(value);
            return this;
        }

        public Builder addAutoFollowedClusters(AutoFollowedCluster value) {
            if (this.autoFollowedClusters == null) {
                this.autoFollowedClusters = new ArrayList<AutoFollowedCluster>();
            }
            this.autoFollowedClusters.add(value);
            return this;
        }

        public Builder autoFollowedClusters(Function<AutoFollowedCluster.Builder, ObjectBuilder<AutoFollowedCluster>> fn) {
            return this.autoFollowedClusters(fn.apply(new AutoFollowedCluster.Builder()).build());
        }

        public Builder addAutoFollowedClusters(Function<AutoFollowedCluster.Builder, ObjectBuilder<AutoFollowedCluster>> fn) {
            return this.addAutoFollowedClusters(fn.apply(new AutoFollowedCluster.Builder()).build());
        }

        public Builder numberOfFailedFollowIndices(long value) {
            this.numberOfFailedFollowIndices = value;
            return this;
        }

        public Builder numberOfFailedRemoteClusterStateRequests(long value) {
            this.numberOfFailedRemoteClusterStateRequests = value;
            return this;
        }

        public Builder numberOfSuccessfulFollowIndices(long value) {
            this.numberOfSuccessfulFollowIndices = value;
            return this;
        }

        public Builder recentAutoFollowErrors(List<ErrorCause> value) {
            this.recentAutoFollowErrors = value;
            return this;
        }

        public Builder recentAutoFollowErrors(ErrorCause ... value) {
            this.recentAutoFollowErrors = Arrays.asList(value);
            return this;
        }

        public Builder addRecentAutoFollowErrors(ErrorCause value) {
            if (this.recentAutoFollowErrors == null) {
                this.recentAutoFollowErrors = new ArrayList<ErrorCause>();
            }
            this.recentAutoFollowErrors.add(value);
            return this;
        }

        public Builder recentAutoFollowErrors(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.recentAutoFollowErrors(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder addRecentAutoFollowErrors(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.addRecentAutoFollowErrors(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        public AutoFollowStats build() {
            return new AutoFollowStats(this);
        }
    }
}

