/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.ccr.ReadException;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShardStats
implements JsonpSerializable {
    private final long bytesRead;
    private final long failedReadRequests;
    private final long failedWriteRequests;
    @Nullable
    private final ErrorCause fatalException;
    private final long followerAliasesVersion;
    private final long followerGlobalCheckpoint;
    private final String followerIndex;
    private final long followerMappingVersion;
    private final int followerMaxSeqNo;
    private final long followerSettingsVersion;
    private final int lastRequestedSeqNo;
    private final long leaderGlobalCheckpoint;
    private final String leaderIndex;
    private final int leaderMaxSeqNo;
    private final long operationsRead;
    private final long operationsWritten;
    private final int outstandingReadRequests;
    private final int outstandingWriteRequests;
    private final List<ReadException> readExceptions;
    private final String remoteCluster;
    private final int shardId;
    private final long successfulReadRequests;
    private final long successfulWriteRequests;
    private final String timeSinceLastReadMillis;
    private final String totalReadRemoteExecTimeMillis;
    private final String totalReadTimeMillis;
    private final String totalWriteTimeMillis;
    private final long writeBufferOperationCount;
    private final String writeBufferSizeInBytes;
    public static final JsonpDeserializer<ShardStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStats::setupShardStatsDeserializer, Builder::build);

    public ShardStats(Builder builder) {
        this.bytesRead = Objects.requireNonNull(builder.bytesRead, "bytes_read");
        this.failedReadRequests = Objects.requireNonNull(builder.failedReadRequests, "failed_read_requests");
        this.failedWriteRequests = Objects.requireNonNull(builder.failedWriteRequests, "failed_write_requests");
        this.fatalException = builder.fatalException;
        this.followerAliasesVersion = Objects.requireNonNull(builder.followerAliasesVersion, "follower_aliases_version");
        this.followerGlobalCheckpoint = Objects.requireNonNull(builder.followerGlobalCheckpoint, "follower_global_checkpoint");
        this.followerIndex = Objects.requireNonNull(builder.followerIndex, "follower_index");
        this.followerMappingVersion = Objects.requireNonNull(builder.followerMappingVersion, "follower_mapping_version");
        this.followerMaxSeqNo = Objects.requireNonNull(builder.followerMaxSeqNo, "follower_max_seq_no");
        this.followerSettingsVersion = Objects.requireNonNull(builder.followerSettingsVersion, "follower_settings_version");
        this.lastRequestedSeqNo = Objects.requireNonNull(builder.lastRequestedSeqNo, "last_requested_seq_no");
        this.leaderGlobalCheckpoint = Objects.requireNonNull(builder.leaderGlobalCheckpoint, "leader_global_checkpoint");
        this.leaderIndex = Objects.requireNonNull(builder.leaderIndex, "leader_index");
        this.leaderMaxSeqNo = Objects.requireNonNull(builder.leaderMaxSeqNo, "leader_max_seq_no");
        this.operationsRead = Objects.requireNonNull(builder.operationsRead, "operations_read");
        this.operationsWritten = Objects.requireNonNull(builder.operationsWritten, "operations_written");
        this.outstandingReadRequests = Objects.requireNonNull(builder.outstandingReadRequests, "outstanding_read_requests");
        this.outstandingWriteRequests = Objects.requireNonNull(builder.outstandingWriteRequests, "outstanding_write_requests");
        this.readExceptions = ModelTypeHelper.unmodifiableNonNull(builder.readExceptions, "read_exceptions");
        this.remoteCluster = Objects.requireNonNull(builder.remoteCluster, "remote_cluster");
        this.shardId = Objects.requireNonNull(builder.shardId, "shard_id");
        this.successfulReadRequests = Objects.requireNonNull(builder.successfulReadRequests, "successful_read_requests");
        this.successfulWriteRequests = Objects.requireNonNull(builder.successfulWriteRequests, "successful_write_requests");
        this.timeSinceLastReadMillis = Objects.requireNonNull(builder.timeSinceLastReadMillis, "time_since_last_read_millis");
        this.totalReadRemoteExecTimeMillis = Objects.requireNonNull(builder.totalReadRemoteExecTimeMillis, "total_read_remote_exec_time_millis");
        this.totalReadTimeMillis = Objects.requireNonNull(builder.totalReadTimeMillis, "total_read_time_millis");
        this.totalWriteTimeMillis = Objects.requireNonNull(builder.totalWriteTimeMillis, "total_write_time_millis");
        this.writeBufferOperationCount = Objects.requireNonNull(builder.writeBufferOperationCount, "write_buffer_operation_count");
        this.writeBufferSizeInBytes = Objects.requireNonNull(builder.writeBufferSizeInBytes, "write_buffer_size_in_bytes");
    }

    public ShardStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long failedReadRequests() {
        return this.failedReadRequests;
    }

    public long failedWriteRequests() {
        return this.failedWriteRequests;
    }

    @Nullable
    public ErrorCause fatalException() {
        return this.fatalException;
    }

    public long followerAliasesVersion() {
        return this.followerAliasesVersion;
    }

    public long followerGlobalCheckpoint() {
        return this.followerGlobalCheckpoint;
    }

    public String followerIndex() {
        return this.followerIndex;
    }

    public long followerMappingVersion() {
        return this.followerMappingVersion;
    }

    public int followerMaxSeqNo() {
        return this.followerMaxSeqNo;
    }

    public long followerSettingsVersion() {
        return this.followerSettingsVersion;
    }

    public int lastRequestedSeqNo() {
        return this.lastRequestedSeqNo;
    }

    public long leaderGlobalCheckpoint() {
        return this.leaderGlobalCheckpoint;
    }

    public String leaderIndex() {
        return this.leaderIndex;
    }

    public int leaderMaxSeqNo() {
        return this.leaderMaxSeqNo;
    }

    public long operationsRead() {
        return this.operationsRead;
    }

    public long operationsWritten() {
        return this.operationsWritten;
    }

    public int outstandingReadRequests() {
        return this.outstandingReadRequests;
    }

    public int outstandingWriteRequests() {
        return this.outstandingWriteRequests;
    }

    public List<ReadException> readExceptions() {
        return this.readExceptions;
    }

    public String remoteCluster() {
        return this.remoteCluster;
    }

    public int shardId() {
        return this.shardId;
    }

    public long successfulReadRequests() {
        return this.successfulReadRequests;
    }

    public long successfulWriteRequests() {
        return this.successfulWriteRequests;
    }

    public String timeSinceLastReadMillis() {
        return this.timeSinceLastReadMillis;
    }

    public String totalReadRemoteExecTimeMillis() {
        return this.totalReadRemoteExecTimeMillis;
    }

    public String totalReadTimeMillis() {
        return this.totalReadTimeMillis;
    }

    public String totalWriteTimeMillis() {
        return this.totalWriteTimeMillis;
    }

    public long writeBufferOperationCount() {
        return this.writeBufferOperationCount;
    }

    public String writeBufferSizeInBytes() {
        return this.writeBufferSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bytes_read");
        generator.write(this.bytesRead);
        generator.writeKey("failed_read_requests");
        generator.write(this.failedReadRequests);
        generator.writeKey("failed_write_requests");
        generator.write(this.failedWriteRequests);
        if (this.fatalException != null) {
            generator.writeKey("fatal_exception");
            this.fatalException.serialize(generator, mapper);
        }
        generator.writeKey("follower_aliases_version");
        generator.write(this.followerAliasesVersion);
        generator.writeKey("follower_global_checkpoint");
        generator.write(this.followerGlobalCheckpoint);
        generator.writeKey("follower_index");
        generator.write(this.followerIndex);
        generator.writeKey("follower_mapping_version");
        generator.write(this.followerMappingVersion);
        generator.writeKey("follower_max_seq_no");
        generator.write(this.followerMaxSeqNo);
        generator.writeKey("follower_settings_version");
        generator.write(this.followerSettingsVersion);
        generator.writeKey("last_requested_seq_no");
        generator.write(this.lastRequestedSeqNo);
        generator.writeKey("leader_global_checkpoint");
        generator.write(this.leaderGlobalCheckpoint);
        generator.writeKey("leader_index");
        generator.write(this.leaderIndex);
        generator.writeKey("leader_max_seq_no");
        generator.write(this.leaderMaxSeqNo);
        generator.writeKey("operations_read");
        generator.write(this.operationsRead);
        generator.writeKey("operations_written");
        generator.write(this.operationsWritten);
        generator.writeKey("outstanding_read_requests");
        generator.write(this.outstandingReadRequests);
        generator.writeKey("outstanding_write_requests");
        generator.write(this.outstandingWriteRequests);
        generator.writeKey("read_exceptions");
        generator.writeStartArray();
        for (ReadException item0 : this.readExceptions) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        generator.writeKey("shard_id");
        generator.write(this.shardId);
        generator.writeKey("successful_read_requests");
        generator.write(this.successfulReadRequests);
        generator.writeKey("successful_write_requests");
        generator.write(this.successfulWriteRequests);
        generator.writeKey("time_since_last_read_millis");
        generator.write(this.timeSinceLastReadMillis);
        generator.writeKey("total_read_remote_exec_time_millis");
        generator.write(this.totalReadRemoteExecTimeMillis);
        generator.writeKey("total_read_time_millis");
        generator.write(this.totalReadTimeMillis);
        generator.writeKey("total_write_time_millis");
        generator.write(this.totalWriteTimeMillis);
        generator.writeKey("write_buffer_operation_count");
        generator.write(this.writeBufferOperationCount);
        generator.writeKey("write_buffer_size_in_bytes");
        generator.write(this.writeBufferSizeInBytes);
    }

    protected static void setupShardStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bytesRead, JsonpDeserializer.longDeserializer(), "bytes_read", new String[0]);
        op.add(Builder::failedReadRequests, JsonpDeserializer.longDeserializer(), "failed_read_requests", new String[0]);
        op.add(Builder::failedWriteRequests, JsonpDeserializer.longDeserializer(), "failed_write_requests", new String[0]);
        op.add(Builder::fatalException, ErrorCause._DESERIALIZER, "fatal_exception", new String[0]);
        op.add(Builder::followerAliasesVersion, JsonpDeserializer.longDeserializer(), "follower_aliases_version", new String[0]);
        op.add(Builder::followerGlobalCheckpoint, JsonpDeserializer.longDeserializer(), "follower_global_checkpoint", new String[0]);
        op.add(Builder::followerIndex, JsonpDeserializer.stringDeserializer(), "follower_index", new String[0]);
        op.add(Builder::followerMappingVersion, JsonpDeserializer.longDeserializer(), "follower_mapping_version", new String[0]);
        op.add(Builder::followerMaxSeqNo, JsonpDeserializer.integerDeserializer(), "follower_max_seq_no", new String[0]);
        op.add(Builder::followerSettingsVersion, JsonpDeserializer.longDeserializer(), "follower_settings_version", new String[0]);
        op.add(Builder::lastRequestedSeqNo, JsonpDeserializer.integerDeserializer(), "last_requested_seq_no", new String[0]);
        op.add(Builder::leaderGlobalCheckpoint, JsonpDeserializer.longDeserializer(), "leader_global_checkpoint", new String[0]);
        op.add(Builder::leaderIndex, JsonpDeserializer.stringDeserializer(), "leader_index", new String[0]);
        op.add(Builder::leaderMaxSeqNo, JsonpDeserializer.integerDeserializer(), "leader_max_seq_no", new String[0]);
        op.add(Builder::operationsRead, JsonpDeserializer.longDeserializer(), "operations_read", new String[0]);
        op.add(Builder::operationsWritten, JsonpDeserializer.longDeserializer(), "operations_written", new String[0]);
        op.add(Builder::outstandingReadRequests, JsonpDeserializer.integerDeserializer(), "outstanding_read_requests", new String[0]);
        op.add(Builder::outstandingWriteRequests, JsonpDeserializer.integerDeserializer(), "outstanding_write_requests", new String[0]);
        op.add(Builder::readExceptions, JsonpDeserializer.arrayDeserializer(ReadException._DESERIALIZER), "read_exceptions", new String[0]);
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster", new String[0]);
        op.add(Builder::shardId, JsonpDeserializer.integerDeserializer(), "shard_id", new String[0]);
        op.add(Builder::successfulReadRequests, JsonpDeserializer.longDeserializer(), "successful_read_requests", new String[0]);
        op.add(Builder::successfulWriteRequests, JsonpDeserializer.longDeserializer(), "successful_write_requests", new String[0]);
        op.add(Builder::timeSinceLastReadMillis, JsonpDeserializer.stringDeserializer(), "time_since_last_read_millis", new String[0]);
        op.add(Builder::totalReadRemoteExecTimeMillis, JsonpDeserializer.stringDeserializer(), "total_read_remote_exec_time_millis", new String[0]);
        op.add(Builder::totalReadTimeMillis, JsonpDeserializer.stringDeserializer(), "total_read_time_millis", new String[0]);
        op.add(Builder::totalWriteTimeMillis, JsonpDeserializer.stringDeserializer(), "total_write_time_millis", new String[0]);
        op.add(Builder::writeBufferOperationCount, JsonpDeserializer.longDeserializer(), "write_buffer_operation_count", new String[0]);
        op.add(Builder::writeBufferSizeInBytes, JsonpDeserializer.stringDeserializer(), "write_buffer_size_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardStats> {
        private Long bytesRead;
        private Long failedReadRequests;
        private Long failedWriteRequests;
        @Nullable
        private ErrorCause fatalException;
        private Long followerAliasesVersion;
        private Long followerGlobalCheckpoint;
        private String followerIndex;
        private Long followerMappingVersion;
        private Integer followerMaxSeqNo;
        private Long followerSettingsVersion;
        private Integer lastRequestedSeqNo;
        private Long leaderGlobalCheckpoint;
        private String leaderIndex;
        private Integer leaderMaxSeqNo;
        private Long operationsRead;
        private Long operationsWritten;
        private Integer outstandingReadRequests;
        private Integer outstandingWriteRequests;
        private List<ReadException> readExceptions;
        private String remoteCluster;
        private Integer shardId;
        private Long successfulReadRequests;
        private Long successfulWriteRequests;
        private String timeSinceLastReadMillis;
        private String totalReadRemoteExecTimeMillis;
        private String totalReadTimeMillis;
        private String totalWriteTimeMillis;
        private Long writeBufferOperationCount;
        private String writeBufferSizeInBytes;

        public Builder bytesRead(long value) {
            this.bytesRead = value;
            return this;
        }

        public Builder failedReadRequests(long value) {
            this.failedReadRequests = value;
            return this;
        }

        public Builder failedWriteRequests(long value) {
            this.failedWriteRequests = value;
            return this;
        }

        public Builder fatalException(@Nullable ErrorCause value) {
            this.fatalException = value;
            return this;
        }

        public Builder fatalException(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.fatalException(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder followerAliasesVersion(long value) {
            this.followerAliasesVersion = value;
            return this;
        }

        public Builder followerGlobalCheckpoint(long value) {
            this.followerGlobalCheckpoint = value;
            return this;
        }

        public Builder followerIndex(String value) {
            this.followerIndex = value;
            return this;
        }

        public Builder followerMappingVersion(long value) {
            this.followerMappingVersion = value;
            return this;
        }

        public Builder followerMaxSeqNo(int value) {
            this.followerMaxSeqNo = value;
            return this;
        }

        public Builder followerSettingsVersion(long value) {
            this.followerSettingsVersion = value;
            return this;
        }

        public Builder lastRequestedSeqNo(int value) {
            this.lastRequestedSeqNo = value;
            return this;
        }

        public Builder leaderGlobalCheckpoint(long value) {
            this.leaderGlobalCheckpoint = value;
            return this;
        }

        public Builder leaderIndex(String value) {
            this.leaderIndex = value;
            return this;
        }

        public Builder leaderMaxSeqNo(int value) {
            this.leaderMaxSeqNo = value;
            return this;
        }

        public Builder operationsRead(long value) {
            this.operationsRead = value;
            return this;
        }

        public Builder operationsWritten(long value) {
            this.operationsWritten = value;
            return this;
        }

        public Builder outstandingReadRequests(int value) {
            this.outstandingReadRequests = value;
            return this;
        }

        public Builder outstandingWriteRequests(int value) {
            this.outstandingWriteRequests = value;
            return this;
        }

        public Builder readExceptions(List<ReadException> value) {
            this.readExceptions = value;
            return this;
        }

        public Builder readExceptions(ReadException ... value) {
            this.readExceptions = Arrays.asList(value);
            return this;
        }

        public Builder addReadExceptions(ReadException value) {
            if (this.readExceptions == null) {
                this.readExceptions = new ArrayList<ReadException>();
            }
            this.readExceptions.add(value);
            return this;
        }

        public Builder readExceptions(Function<ReadException.Builder, ObjectBuilder<ReadException>> fn) {
            return this.readExceptions(fn.apply(new ReadException.Builder()).build());
        }

        public Builder addReadExceptions(Function<ReadException.Builder, ObjectBuilder<ReadException>> fn) {
            return this.addReadExceptions(fn.apply(new ReadException.Builder()).build());
        }

        public Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public Builder shardId(int value) {
            this.shardId = value;
            return this;
        }

        public Builder successfulReadRequests(long value) {
            this.successfulReadRequests = value;
            return this;
        }

        public Builder successfulWriteRequests(long value) {
            this.successfulWriteRequests = value;
            return this;
        }

        public Builder timeSinceLastReadMillis(String value) {
            this.timeSinceLastReadMillis = value;
            return this;
        }

        public Builder totalReadRemoteExecTimeMillis(String value) {
            this.totalReadRemoteExecTimeMillis = value;
            return this;
        }

        public Builder totalReadTimeMillis(String value) {
            this.totalReadTimeMillis = value;
            return this;
        }

        public Builder totalWriteTimeMillis(String value) {
            this.totalWriteTimeMillis = value;
            return this;
        }

        public Builder writeBufferOperationCount(long value) {
            this.writeBufferOperationCount = value;
            return this;
        }

        public Builder writeBufferSizeInBytes(String value) {
            this.writeBufferSizeInBytes = value;
            return this;
        }

        @Override
        public ShardStats build() {
            return new ShardStats(this);
        }
    }
}

