/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.tasks.TasksRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class TasksResponse
implements JsonpSerializable {
    private final List<TasksRecord> valueBody;
    public static final JsonpDeserializer<TasksResponse> _DESERIALIZER = TasksResponse.createTasksResponseDeserializer();

    public TasksResponse(Builder builder) {
        this.valueBody = ModelTypeHelper.unmodifiableNonNull(builder.valueBody, "_value_body");
    }

    public TasksResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<TasksRecord> valueBody() {
        return this.valueBody;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (TasksRecord item0 : this.valueBody) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<TasksResponse> createTasksResponseDeserializer() {
        JsonpDeserializer<List<TasksRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(TasksRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().valueBody((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<TasksResponse> {
        private List<TasksRecord> valueBody;

        public Builder valueBody(List<TasksRecord> value) {
            this.valueBody = value;
            return this;
        }

        public Builder valueBody(TasksRecord ... value) {
            this.valueBody = Arrays.asList(value);
            return this;
        }

        public Builder addValueBody(TasksRecord value) {
            if (this.valueBody == null) {
                this.valueBody = new ArrayList<TasksRecord>();
            }
            this.valueBody.add(value);
            return this;
        }

        public Builder valueBody(Function<TasksRecord.Builder, ObjectBuilder<TasksRecord>> fn) {
            return this.valueBody(fn.apply(new TasksRecord.Builder()).build());
        }

        public Builder addValueBody(Function<TasksRecord.Builder, ObjectBuilder<TasksRecord>> fn) {
            return this.addValueBody(fn.apply(new TasksRecord.Builder()).build());
        }

        @Override
        public TasksResponse build() {
            return new TasksResponse(this);
        }
    }
}

