/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.SegmentsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class SegmentsRequest
extends CatRequestBase {
    @Nullable
    private final List<String> index;
    @Nullable
    private final Bytes bytes;
    public static final Endpoint<SegmentsRequest, SegmentsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<SegmentsRequest, SegmentsResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/segments");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/segments");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SegmentsResponse._DESERIALIZER);

    public SegmentsRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.bytes = builder.bytes;
    }

    public SegmentsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    public static class Builder
    implements ObjectBuilder<SegmentsRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private Bytes bytes;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Override
        public SegmentsRequest build() {
            return new SegmentsRequest(this);
        }
    }
}

