/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlDataFrameAnalyticsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MlDataFrameAnalyticsRequest
extends CatRequestBase {
    @Nullable
    private final String id;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Bytes bytes;
    public static final Endpoint<MlDataFrameAnalyticsRequest, MlDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<MlDataFrameAnalyticsRequest, MlDataFrameAnalyticsResponse>(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlDataFrameAnalyticsResponse._DESERIALIZER);

    public MlDataFrameAnalyticsRequest(Builder builder) {
        this.id = builder.id;
        this.allowNoMatch = builder.allowNoMatch;
        this.bytes = builder.bytes;
    }

    public MlDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    public static class Builder
    implements ObjectBuilder<MlDataFrameAnalyticsRequest> {
        @Nullable
        private String id;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Bytes bytes;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Override
        public MlDataFrameAnalyticsRequest build() {
            return new MlDataFrameAnalyticsRequest(this);
        }
    }
}

