/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.HealthResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HealthRequest
extends CatRequestBase {
    @Nullable
    private final Boolean includeTimestamp;
    @Nullable
    private final Boolean ts;
    public static final Endpoint<HealthRequest, HealthResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<HealthRequest, HealthResponse>(request -> "GET", request -> "/_cat/health", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.includeTimestamp != null) {
            params.put("include_timestamp", String.valueOf(request.includeTimestamp));
        }
        if (request.ts != null) {
            params.put("ts", String.valueOf(request.ts));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, HealthResponse._DESERIALIZER);

    public HealthRequest(Builder builder) {
        this.includeTimestamp = builder.includeTimestamp;
        this.ts = builder.ts;
    }

    public HealthRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean includeTimestamp() {
        return this.includeTimestamp;
    }

    @Nullable
    public Boolean ts() {
        return this.ts;
    }

    public static class Builder
    implements ObjectBuilder<HealthRequest> {
        @Nullable
        private Boolean includeTimestamp;
        @Nullable
        private Boolean ts;

        public Builder includeTimestamp(@Nullable Boolean value) {
            this.includeTimestamp = value;
            return this;
        }

        public Builder ts(@Nullable Boolean value) {
            this.ts = value;
            return this;
        }

        @Override
        public HealthRequest build() {
            return new HealthRequest(this);
        }
    }
}

