/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.allocation.AllocationRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class AllocationResponse
implements JsonpSerializable {
    private final List<AllocationRecord> valueBody;
    public static final JsonpDeserializer<AllocationResponse> _DESERIALIZER = AllocationResponse.createAllocationResponseDeserializer();

    public AllocationResponse(Builder builder) {
        this.valueBody = ModelTypeHelper.unmodifiableNonNull(builder.valueBody, "_value_body");
    }

    public AllocationResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<AllocationRecord> valueBody() {
        return this.valueBody;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (AllocationRecord item0 : this.valueBody) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<AllocationResponse> createAllocationResponseDeserializer() {
        JsonpDeserializer<List<AllocationRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(AllocationRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().valueBody((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<AllocationResponse> {
        private List<AllocationRecord> valueBody;

        public Builder valueBody(List<AllocationRecord> value) {
            this.valueBody = value;
            return this;
        }

        public Builder valueBody(AllocationRecord ... value) {
            this.valueBody = Arrays.asList(value);
            return this;
        }

        public Builder addValueBody(AllocationRecord value) {
            if (this.valueBody == null) {
                this.valueBody = new ArrayList<AllocationRecord>();
            }
            this.valueBody.add(value);
            return this;
        }

        public Builder valueBody(Function<AllocationRecord.Builder, ObjectBuilder<AllocationRecord>> fn) {
            return this.valueBody(fn.apply(new AllocationRecord.Builder()).build());
        }

        public Builder addValueBody(Function<AllocationRecord.Builder, ObjectBuilder<AllocationRecord>> fn) {
            return this.addValueBody(fn.apply(new AllocationRecord.Builder()).build());
        }

        @Override
        public AllocationResponse build() {
            return new AllocationResponse(this);
        }
    }
}

