/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AutoscalingResources
implements JsonpSerializable {
    private final int storage;
    private final int memory;
    public static final JsonpDeserializer<AutoscalingResources> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoscalingResources::setupAutoscalingResourcesDeserializer, Builder::build);

    public AutoscalingResources(Builder builder) {
        this.storage = Objects.requireNonNull(builder.storage, "storage");
        this.memory = Objects.requireNonNull(builder.memory, "memory");
    }

    public AutoscalingResources(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int storage() {
        return this.storage;
    }

    public int memory() {
        return this.memory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("storage");
        generator.write(this.storage);
        generator.writeKey("memory");
        generator.write(this.memory);
    }

    protected static void setupAutoscalingResourcesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::storage, JsonpDeserializer.integerDeserializer(), "storage", new String[0]);
        op.add(Builder::memory, JsonpDeserializer.integerDeserializer(), "memory", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AutoscalingResources> {
        private Integer storage;
        private Integer memory;

        public Builder storage(int value) {
            this.storage = value;
            return this;
        }

        public Builder memory(int value) {
            this.memory = value;
            return this;
        }

        @Override
        public AutoscalingResources build() {
            return new AutoscalingResources(this);
        }
    }
}

