/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity;

import co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity.AutoscalingCapacity;
import co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity.AutoscalingDecider;
import co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity.AutoscalingNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AutoscalingDeciders
implements JsonpSerializable {
    private final AutoscalingCapacity requiredCapacity;
    private final AutoscalingCapacity currentCapacity;
    private final List<AutoscalingNode> currentNodes;
    private final Map<String, AutoscalingDecider> deciders;
    public static final JsonpDeserializer<AutoscalingDeciders> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoscalingDeciders::setupAutoscalingDecidersDeserializer, Builder::build);

    public AutoscalingDeciders(Builder builder) {
        this.requiredCapacity = Objects.requireNonNull(builder.requiredCapacity, "required_capacity");
        this.currentCapacity = Objects.requireNonNull(builder.currentCapacity, "current_capacity");
        this.currentNodes = ModelTypeHelper.unmodifiableNonNull(builder.currentNodes, "current_nodes");
        this.deciders = ModelTypeHelper.unmodifiableNonNull(builder.deciders, "deciders");
    }

    public AutoscalingDeciders(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AutoscalingCapacity requiredCapacity() {
        return this.requiredCapacity;
    }

    public AutoscalingCapacity currentCapacity() {
        return this.currentCapacity;
    }

    public List<AutoscalingNode> currentNodes() {
        return this.currentNodes;
    }

    public Map<String, AutoscalingDecider> deciders() {
        return this.deciders;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("required_capacity");
        this.requiredCapacity.serialize(generator, mapper);
        generator.writeKey("current_capacity");
        this.currentCapacity.serialize(generator, mapper);
        generator.writeKey("current_nodes");
        generator.writeStartArray();
        for (AutoscalingNode autoscalingNode : this.currentNodes) {
            autoscalingNode.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("deciders");
        generator.writeStartObject();
        for (Map.Entry entry : this.deciders.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((AutoscalingDecider)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupAutoscalingDecidersDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::requiredCapacity, AutoscalingCapacity._DESERIALIZER, "required_capacity", new String[0]);
        op.add(Builder::currentCapacity, AutoscalingCapacity._DESERIALIZER, "current_capacity", new String[0]);
        op.add(Builder::currentNodes, JsonpDeserializer.arrayDeserializer(AutoscalingNode._DESERIALIZER), "current_nodes", new String[0]);
        op.add(Builder::deciders, JsonpDeserializer.stringMapDeserializer(AutoscalingDecider._DESERIALIZER), "deciders", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AutoscalingDeciders> {
        private AutoscalingCapacity requiredCapacity;
        private AutoscalingCapacity currentCapacity;
        private List<AutoscalingNode> currentNodes;
        private Map<String, AutoscalingDecider> deciders;

        public Builder requiredCapacity(AutoscalingCapacity value) {
            this.requiredCapacity = value;
            return this;
        }

        public Builder requiredCapacity(Function<AutoscalingCapacity.Builder, ObjectBuilder<AutoscalingCapacity>> fn) {
            return this.requiredCapacity(fn.apply(new AutoscalingCapacity.Builder()).build());
        }

        public Builder currentCapacity(AutoscalingCapacity value) {
            this.currentCapacity = value;
            return this;
        }

        public Builder currentCapacity(Function<AutoscalingCapacity.Builder, ObjectBuilder<AutoscalingCapacity>> fn) {
            return this.currentCapacity(fn.apply(new AutoscalingCapacity.Builder()).build());
        }

        public Builder currentNodes(List<AutoscalingNode> value) {
            this.currentNodes = value;
            return this;
        }

        public Builder currentNodes(AutoscalingNode ... value) {
            this.currentNodes = Arrays.asList(value);
            return this;
        }

        public Builder addCurrentNodes(AutoscalingNode value) {
            if (this.currentNodes == null) {
                this.currentNodes = new ArrayList<AutoscalingNode>();
            }
            this.currentNodes.add(value);
            return this;
        }

        public Builder currentNodes(Function<AutoscalingNode.Builder, ObjectBuilder<AutoscalingNode>> fn) {
            return this.currentNodes(fn.apply(new AutoscalingNode.Builder()).build());
        }

        public Builder addCurrentNodes(Function<AutoscalingNode.Builder, ObjectBuilder<AutoscalingNode>> fn) {
            return this.addCurrentNodes(fn.apply(new AutoscalingNode.Builder()).build());
        }

        public Builder deciders(Map<String, AutoscalingDecider> value) {
            this.deciders = value;
            return this;
        }

        public Builder putDeciders(String key, AutoscalingDecider value) {
            if (this.deciders == null) {
                this.deciders = new HashMap<String, AutoscalingDecider>();
            }
            this.deciders.put(key, value);
            return this;
        }

        public Builder deciders(String key, Function<AutoscalingDecider.Builder, ObjectBuilder<AutoscalingDecider>> fn) {
            return this.deciders(Collections.singletonMap(key, fn.apply(new AutoscalingDecider.Builder()).build()));
        }

        public Builder putDeciders(String key, Function<AutoscalingDecider.Builder, ObjectBuilder<AutoscalingDecider>> fn) {
            return this.putDeciders(key, fn.apply(new AutoscalingDecider.Builder()).build());
        }

        @Override
        public AutoscalingDeciders build() {
            return new AutoscalingDeciders(this);
        }
    }
}

