/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class AutoscalingPolicy
implements JsonpSerializable {
    private final List<String> roles;
    private final Map<String, JsonData> deciders;
    public static final JsonpDeserializer<AutoscalingPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoscalingPolicy::setupAutoscalingPolicyDeserializer, Builder::build);

    public AutoscalingPolicy(Builder builder) {
        this.roles = ModelTypeHelper.unmodifiableNonNull(builder.roles, "roles");
        this.deciders = ModelTypeHelper.unmodifiableNonNull(builder.deciders, "deciders");
    }

    public AutoscalingPolicy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> roles() {
        return this.roles;
    }

    public Map<String, JsonData> deciders() {
        return this.deciders;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("roles");
        generator.writeStartArray();
        for (String string : this.roles) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("deciders");
        generator.writeStartObject();
        for (Map.Entry entry : this.deciders.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupAutoscalingPolicyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles", new String[0]);
        op.add(Builder::deciders, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "deciders", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AutoscalingPolicy> {
        private List<String> roles;
        private Map<String, JsonData> deciders;

        public Builder roles(List<String> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(String ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(String value) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            this.roles.add(value);
            return this;
        }

        public Builder deciders(Map<String, JsonData> value) {
            this.deciders = value;
            return this;
        }

        public Builder putDeciders(String key, JsonData value) {
            if (this.deciders == null) {
                this.deciders = new HashMap<String, JsonData>();
            }
            this.deciders.put(key, value);
            return this;
        }

        @Override
        public AutoscalingPolicy build() {
            return new AutoscalingPolicy(this);
        }
    }
}

