/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.SpanContainingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanFieldMaskingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanFirstQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanGapQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanMultiTermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanNearQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanNotQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanOrQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanTermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanWithinQuery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class SpanQuery
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String SPAN_CONTAINING = "span_containing";
    public static final String FIELD_MASKING_SPAN = "field_masking_span";
    public static final String SPAN_FIRST = "span_first";
    public static final String SPAN_GAP = "span_gap";
    public static final String SPAN_MULTI = "span_multi";
    public static final String SPAN_NEAR = "span_near";
    public static final String SPAN_NOT = "span_not";
    public static final String SPAN_OR = "span_or";
    public static final String SPAN_TERM = "span_term";
    public static final String SPAN_WITHIN = "span_within";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<SpanQuery> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, SpanQuery::setupSpanQueryDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public SpanQuery(SpanQueryVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends SpanQueryVariant> SpanQuery(ObjectBuilder<T> builder) {
        this((SpanQueryVariant)builder.build());
    }

    private SpanQuery(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public SpanQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public SpanContainingQuery spanContaining() {
        return (SpanContainingQuery)TaggedUnionUtils.get(this, SPAN_CONTAINING);
    }

    public SpanFieldMaskingQuery fieldMaskingSpan() {
        return (SpanFieldMaskingQuery)TaggedUnionUtils.get(this, FIELD_MASKING_SPAN);
    }

    public SpanFirstQuery spanFirst() {
        return (SpanFirstQuery)TaggedUnionUtils.get(this, SPAN_FIRST);
    }

    public SpanGapQuery spanGap() {
        return (SpanGapQuery)TaggedUnionUtils.get(this, SPAN_GAP);
    }

    public SpanMultiTermQuery spanMulti() {
        return (SpanMultiTermQuery)TaggedUnionUtils.get(this, SPAN_MULTI);
    }

    public SpanNearQuery spanNear() {
        return (SpanNearQuery)TaggedUnionUtils.get(this, SPAN_NEAR);
    }

    public SpanNotQuery spanNot() {
        return (SpanNotQuery)TaggedUnionUtils.get(this, SPAN_NOT);
    }

    public SpanOrQuery spanOr() {
        return (SpanOrQuery)TaggedUnionUtils.get(this, SPAN_OR);
    }

    public SpanTermQuery spanTerm() {
        return (SpanTermQuery)TaggedUnionUtils.get(this, SPAN_TERM);
    }

    public SpanWithinQuery spanWithin() {
        return (SpanWithinQuery)TaggedUnionUtils.get(this, SPAN_WITHIN);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSpanQueryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::spanContaining, SpanContainingQuery._DESERIALIZER, SPAN_CONTAINING, new String[0]);
        op.add(Builder::fieldMaskingSpan, SpanFieldMaskingQuery._DESERIALIZER, FIELD_MASKING_SPAN, new String[0]);
        op.add(Builder::spanFirst, SpanFirstQuery._DESERIALIZER, SPAN_FIRST, new String[0]);
        op.add(Builder::spanGap, SpanGapQuery._DESERIALIZER, SPAN_GAP, new String[0]);
        op.add(Builder::spanMulti, SpanMultiTermQuery._DESERIALIZER, SPAN_MULTI, new String[0]);
        op.add(Builder::spanNear, SpanNearQuery._DESERIALIZER, SPAN_NEAR, new String[0]);
        op.add(Builder::spanNot, SpanNotQuery._DESERIALIZER, SPAN_NOT, new String[0]);
        op.add(Builder::spanOr, SpanOrQuery._DESERIALIZER, SPAN_OR, new String[0]);
        op.add(Builder::spanTerm, SpanTermQuery._DESERIALIZER, SPAN_TERM, new String[0]);
        op.add(Builder::spanWithin, SpanWithinQuery._DESERIALIZER, SPAN_WITHIN, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SpanQuery> {
        private String _type;
        private Object _value;

        public Builder spanContaining(SpanContainingQuery v) {
            this._type = SpanQuery.SPAN_CONTAINING;
            this._value = v;
            return this;
        }

        public Builder spanContaining(Function<SpanContainingQuery.Builder, ObjectBuilder<SpanContainingQuery>> f) {
            return this.spanContaining(f.apply(new SpanContainingQuery.Builder()).build());
        }

        public Builder fieldMaskingSpan(SpanFieldMaskingQuery v) {
            this._type = SpanQuery.FIELD_MASKING_SPAN;
            this._value = v;
            return this;
        }

        public Builder fieldMaskingSpan(Function<SpanFieldMaskingQuery.Builder, ObjectBuilder<SpanFieldMaskingQuery>> f) {
            return this.fieldMaskingSpan(f.apply(new SpanFieldMaskingQuery.Builder()).build());
        }

        public Builder spanFirst(SpanFirstQuery v) {
            this._type = SpanQuery.SPAN_FIRST;
            this._value = v;
            return this;
        }

        public Builder spanFirst(Function<SpanFirstQuery.Builder, ObjectBuilder<SpanFirstQuery>> f) {
            return this.spanFirst(f.apply(new SpanFirstQuery.Builder()).build());
        }

        public Builder spanGap(SpanGapQuery v) {
            this._type = SpanQuery.SPAN_GAP;
            this._value = v;
            return this;
        }

        public Builder spanGap(Function<SpanGapQuery.Builder, ObjectBuilder<SpanGapQuery>> f) {
            return this.spanGap(f.apply(new SpanGapQuery.Builder()).build());
        }

        public Builder spanMulti(SpanMultiTermQuery v) {
            this._type = SpanQuery.SPAN_MULTI;
            this._value = v;
            return this;
        }

        public Builder spanMulti(Function<SpanMultiTermQuery.Builder, ObjectBuilder<SpanMultiTermQuery>> f) {
            return this.spanMulti(f.apply(new SpanMultiTermQuery.Builder()).build());
        }

        public Builder spanNear(SpanNearQuery v) {
            this._type = SpanQuery.SPAN_NEAR;
            this._value = v;
            return this;
        }

        public Builder spanNear(Function<SpanNearQuery.Builder, ObjectBuilder<SpanNearQuery>> f) {
            return this.spanNear(f.apply(new SpanNearQuery.Builder()).build());
        }

        public Builder spanNot(SpanNotQuery v) {
            this._type = SpanQuery.SPAN_NOT;
            this._value = v;
            return this;
        }

        public Builder spanNot(Function<SpanNotQuery.Builder, ObjectBuilder<SpanNotQuery>> f) {
            return this.spanNot(f.apply(new SpanNotQuery.Builder()).build());
        }

        public Builder spanOr(SpanOrQuery v) {
            this._type = SpanQuery.SPAN_OR;
            this._value = v;
            return this;
        }

        public Builder spanOr(Function<SpanOrQuery.Builder, ObjectBuilder<SpanOrQuery>> f) {
            return this.spanOr(f.apply(new SpanOrQuery.Builder()).build());
        }

        public Builder spanTerm(SpanTermQuery v) {
            this._type = SpanQuery.SPAN_TERM;
            this._value = v;
            return this;
        }

        public Builder spanTerm(Function<SpanTermQuery.Builder, ObjectBuilder<SpanTermQuery>> f) {
            return this.spanTerm(f.apply(new SpanTermQuery.Builder()).build());
        }

        public Builder spanWithin(SpanWithinQuery v) {
            this._type = SpanQuery.SPAN_WITHIN;
            this._value = v;
            return this;
        }

        public Builder spanWithin(Function<SpanWithinQuery.Builder, ObjectBuilder<SpanWithinQuery>> f) {
            return this.spanWithin(f.apply(new SpanWithinQuery.Builder()).build());
        }

        @Override
        public SpanQuery build() {
            return new SpanQuery(this);
        }
    }
}

