/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.ShapeFieldQuery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShapeQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final ShapeFieldQuery shape;
    public static final JsonpDeserializer<ShapeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShapeQuery::setupShapeQueryDeserializer, Builder::build);

    public ShapeQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.shape = Objects.requireNonNull(builder.shape, "shape");
    }

    public ShapeQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "shape";
    }

    public String field() {
        return this.field;
    }

    public ShapeFieldQuery shape() {
        return this.shape;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.shape.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
    }

    protected static void setupShapeQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.shape(ShapeFieldQuery._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ShapeQuery> {
        private String field;
        private ShapeFieldQuery shape;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder shape(ShapeFieldQuery value) {
            this.shape = value;
            return this;
        }

        public Builder shape(Function<ShapeFieldQuery.Builder, ObjectBuilder<ShapeFieldQuery>> fn) {
            return this.shape(fn.apply(new ShapeFieldQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShapeQuery build() {
            return new ShapeQuery(this);
        }
    }
}

