/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.PinnedDoc;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class PinnedQuery
extends QueryBase
implements TaggedUnion<Object>,
QueryVariant,
JsonpSerializable {
    public static final String IDS = "ids";
    public static final String DOCS = "docs";
    private final String _type;
    private final Object _value;
    private final Query organic;
    public static final JsonpDeserializer<PinnedQuery> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, PinnedQuery::setupPinnedQueryDeserializer, Builder::build);

    @Override
    public String _variantType() {
        return "pinned";
    }

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    private PinnedQuery(Builder builder) {
        super(builder);
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
        this.organic = Objects.requireNonNull(builder.organic, "organic");
    }

    public PinnedQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Query organic() {
        return this.organic;
    }

    public List<String> ids() {
        return (List)TaggedUnionUtils.get(this, IDS);
    }

    public List<PinnedDoc> docs() {
        return (List)TaggedUnionUtils.get(this, DOCS);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        super.serializeInternal(generator, mapper);
        generator.writeKey("organic");
        this.organic.serialize(generator, mapper);
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "ids": {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case "docs": {
                    generator.writeStartArray();
                    for (PinnedDoc item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupPinnedQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::organic, Query._DESERIALIZER, "organic", new String[0]);
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), IDS, new String[0]);
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(PinnedDoc._DESERIALIZER), DOCS, new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder> {
        private String _type;
        private Object _value;
        private Query organic;

        public Builder organic(Query value) {
            this.organic = value;
            return this;
        }

        public Builder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.organic(fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder ids(List<String> v) {
            this._type = PinnedQuery.IDS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder docs(List<PinnedDoc> v) {
            this._type = PinnedQuery.DOCS;
            this._value = v;
            return new ContainerBuilder();
        }

        protected PinnedQuery build() {
            return new PinnedQuery(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<PinnedQuery> {
            public ContainerBuilder organic(Query value) {
                Builder.this.organic = value;
                return this;
            }

            public ContainerBuilder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
                return this.organic(fn.apply(new Query.Builder()).build());
            }

            @Override
            public PinnedQuery build() {
                return Builder.this.build();
            }
        }
    }
}

