/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.TextQueryType;
import co.elastic.clients.elasticsearch._types.query_dsl.ZeroTermsQuery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MultiMatchQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final Double cutoffFrequency;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final String fuzzyRewrite;
    @Nullable
    private final Boolean fuzzyTranspositions;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Integer maxExpansions;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final Operator operator;
    @Nullable
    private final Integer prefixLength;
    private final String query;
    @Nullable
    private final Integer slop;
    @Nullable
    private final Double tieBreaker;
    @Nullable
    private final TextQueryType type;
    @Nullable
    private final ZeroTermsQuery zeroTermsQuery;
    public static final JsonpDeserializer<MultiMatchQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiMatchQuery::setupMultiMatchQueryDeserializer, Builder::build);

    public MultiMatchQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.cutoffFrequency = builder.cutoffFrequency;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.fuzziness = builder.fuzziness;
        this.fuzzyRewrite = builder.fuzzyRewrite;
        this.fuzzyTranspositions = builder.fuzzyTranspositions;
        this.lenient = builder.lenient;
        this.maxExpansions = builder.maxExpansions;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.operator = builder.operator;
        this.prefixLength = builder.prefixLength;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.slop = builder.slop;
        this.tieBreaker = builder.tieBreaker;
        this.type = builder.type;
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public MultiMatchQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "multi_match";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public Double cutoffFrequency() {
        return this.cutoffFrequency;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    @Nullable
    public Boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Nullable
    public Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public Integer maxExpansions() {
        return this.maxExpansions;
    }

    @Nullable
    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public Operator operator() {
        return this.operator;
    }

    @Nullable
    public Integer prefixLength() {
        return this.prefixLength;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public Integer slop() {
        return this.slop;
    }

    @Nullable
    public Double tieBreaker() {
        return this.tieBreaker;
    }

    @Nullable
    public TextQueryType type() {
        return this.type;
    }

    @Nullable
    public ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.cutoffFrequency != null) {
            generator.writeKey("cutoff_frequency");
            generator.write(this.cutoffFrequency.doubleValue());
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.fuzzyRewrite != null) {
            generator.writeKey("fuzzy_rewrite");
            generator.write(this.fuzzyRewrite);
        }
        if (this.fuzzyTranspositions != null) {
            generator.writeKey("fuzzy_transpositions");
            generator.write(this.fuzzyTranspositions.booleanValue());
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.maxExpansions != null) {
            generator.writeKey("max_expansions");
            generator.write(this.maxExpansions.intValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.operator != null) {
            generator.writeKey("operator");
            this.operator.serialize(generator, mapper);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.slop != null) {
            generator.writeKey("slop");
            generator.write(this.slop.intValue());
        }
        if (this.tieBreaker != null) {
            generator.writeKey("tie_breaker");
            generator.write(this.tieBreaker.doubleValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
    }

    protected static void setupMultiMatchQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query", new String[0]);
        op.add(Builder::cutoffFrequency, JsonpDeserializer.doubleDeserializer(), "cutoff_frequency", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness", new String[0]);
        op.add(Builder::fuzzyRewrite, JsonpDeserializer.stringDeserializer(), "fuzzy_rewrite", new String[0]);
        op.add(Builder::fuzzyTranspositions, JsonpDeserializer.booleanDeserializer(), "fuzzy_transpositions", new String[0]);
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient", new String[0]);
        op.add(Builder::maxExpansions, JsonpDeserializer.integerDeserializer(), "max_expansions", new String[0]);
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match", new String[0]);
        op.add(Builder::operator, Operator._DESERIALIZER, "operator", new String[0]);
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::slop, JsonpDeserializer.integerDeserializer(), "slop", new String[0]);
        op.add(Builder::tieBreaker, JsonpDeserializer.doubleDeserializer(), "tie_breaker", new String[0]);
        op.add(Builder::type, TextQueryType._DESERIALIZER, "type", new String[0]);
        op.add(Builder::zeroTermsQuery, ZeroTermsQuery._DESERIALIZER, "zero_terms_query", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiMatchQuery> {
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private Double cutoffFrequency;
        @Nullable
        private List<String> fields;
        @Nullable
        private String fuzziness;
        @Nullable
        private String fuzzyRewrite;
        @Nullable
        private Boolean fuzzyTranspositions;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Integer maxExpansions;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private Operator operator;
        @Nullable
        private Integer prefixLength;
        private String query;
        @Nullable
        private Integer slop;
        @Nullable
        private Double tieBreaker;
        @Nullable
        private TextQueryType type;
        @Nullable
        private ZeroTermsQuery zeroTermsQuery;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        public Builder cutoffFrequency(@Nullable Double value) {
            this.cutoffFrequency = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public Builder fuzzyRewrite(@Nullable String value) {
            this.fuzzyRewrite = value;
            return this;
        }

        public Builder fuzzyTranspositions(@Nullable Boolean value) {
            this.fuzzyTranspositions = value;
            return this;
        }

        public Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder maxExpansions(@Nullable Integer value) {
            this.maxExpansions = value;
            return this;
        }

        public Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public Builder operator(@Nullable Operator value) {
            this.operator = value;
            return this;
        }

        public Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder slop(@Nullable Integer value) {
            this.slop = value;
            return this;
        }

        public Builder tieBreaker(@Nullable Double value) {
            this.tieBreaker = value;
            return this;
        }

        public Builder type(@Nullable TextQueryType value) {
            this.type = value;
            return this;
        }

        public Builder zeroTermsQuery(@Nullable ZeroTermsQuery value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiMatchQuery build() {
            return new MultiMatchQuery(this);
        }
    }
}

