/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.query_dsl.LikeDocument;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MoreLikeThisQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Double boostTerms;
    @Nullable
    private final Boolean failOnUnsupportedField;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Boolean include;
    private final List<LikeDocument> like;
    @Nullable
    private final Integer maxDocFreq;
    @Nullable
    private final Integer maxQueryTerms;
    @Nullable
    private final Integer maxWordLength;
    @Nullable
    private final Integer minDocFreq;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final Integer minTermFreq;
    @Nullable
    private final Integer minWordLength;
    @Nullable
    private final Map<String, String> perFieldAnalyzer;
    @Nullable
    private final String routing;
    @Nullable
    private final List<String> stopWords;
    @Nullable
    private final List<LikeDocument> unlike;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MoreLikeThisQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MoreLikeThisQuery::setupMoreLikeThisQueryDeserializer, Builder::build);

    public MoreLikeThisQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.boostTerms = builder.boostTerms;
        this.failOnUnsupportedField = builder.failOnUnsupportedField;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.include = builder.include;
        this.like = ModelTypeHelper.unmodifiableNonNull(builder.like, "like");
        this.maxDocFreq = builder.maxDocFreq;
        this.maxQueryTerms = builder.maxQueryTerms;
        this.maxWordLength = builder.maxWordLength;
        this.minDocFreq = builder.minDocFreq;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.minTermFreq = builder.minTermFreq;
        this.minWordLength = builder.minWordLength;
        this.perFieldAnalyzer = ModelTypeHelper.unmodifiable(builder.perFieldAnalyzer);
        this.routing = builder.routing;
        this.stopWords = ModelTypeHelper.unmodifiable(builder.stopWords);
        this.unlike = ModelTypeHelper.unmodifiable(builder.unlike);
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public MoreLikeThisQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "more_like_this";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Double boostTerms() {
        return this.boostTerms;
    }

    @Nullable
    public Boolean failOnUnsupportedField() {
        return this.failOnUnsupportedField;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Boolean include() {
        return this.include;
    }

    public List<LikeDocument> like() {
        return this.like;
    }

    @Nullable
    public Integer maxDocFreq() {
        return this.maxDocFreq;
    }

    @Nullable
    public Integer maxQueryTerms() {
        return this.maxQueryTerms;
    }

    @Nullable
    public Integer maxWordLength() {
        return this.maxWordLength;
    }

    @Nullable
    public Integer minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public Integer minTermFreq() {
        return this.minTermFreq;
    }

    @Nullable
    public Integer minWordLength() {
        return this.minWordLength;
    }

    @Nullable
    public Map<String, String> perFieldAnalyzer() {
        return this.perFieldAnalyzer;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public List<String> stopWords() {
        return this.stopWords;
    }

    @Nullable
    public List<LikeDocument> unlike() {
        return this.unlike;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.boostTerms != null) {
            generator.writeKey("boost_terms");
            generator.write(this.boostTerms.doubleValue());
        }
        if (this.failOnUnsupportedField != null) {
            generator.writeKey("fail_on_unsupported_field");
            generator.write(this.failOnUnsupportedField.booleanValue());
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.include != null) {
            generator.writeKey("include");
            generator.write(this.include.booleanValue());
        }
        generator.writeKey("like");
        generator.writeStartArray();
        for (LikeDocument likeDocument : this.like) {
            likeDocument.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.maxDocFreq != null) {
            generator.writeKey("max_doc_freq");
            generator.write(this.maxDocFreq.intValue());
        }
        if (this.maxQueryTerms != null) {
            generator.writeKey("max_query_terms");
            generator.write(this.maxQueryTerms.intValue());
        }
        if (this.maxWordLength != null) {
            generator.writeKey("max_word_length");
            generator.write(this.maxWordLength.intValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write(this.minDocFreq.intValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.minTermFreq != null) {
            generator.writeKey("min_term_freq");
            generator.write(this.minTermFreq.intValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength.intValue());
        }
        if (this.perFieldAnalyzer != null) {
            generator.writeKey("per_field_analyzer");
            generator.writeStartObject();
            for (Map.Entry entry : this.perFieldAnalyzer.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.stopWords != null) {
            generator.writeKey("stop_words");
            generator.writeStartArray();
            for (String string : this.stopWords) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.unlike != null) {
            generator.writeKey("unlike");
            generator.writeStartArray();
            for (LikeDocument likeDocument : this.unlike) {
                likeDocument.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static void setupMoreLikeThisQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::boostTerms, JsonpDeserializer.doubleDeserializer(), "boost_terms", new String[0]);
        op.add(Builder::failOnUnsupportedField, JsonpDeserializer.booleanDeserializer(), "fail_on_unsupported_field", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::include, JsonpDeserializer.booleanDeserializer(), "include", new String[0]);
        op.add(Builder::like, JsonpDeserializer.arrayDeserializer(LikeDocument._DESERIALIZER), "like", new String[0]);
        op.add(Builder::maxDocFreq, JsonpDeserializer.integerDeserializer(), "max_doc_freq", new String[0]);
        op.add(Builder::maxQueryTerms, JsonpDeserializer.integerDeserializer(), "max_query_terms", new String[0]);
        op.add(Builder::maxWordLength, JsonpDeserializer.integerDeserializer(), "max_word_length", new String[0]);
        op.add(Builder::minDocFreq, JsonpDeserializer.integerDeserializer(), "min_doc_freq", new String[0]);
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match", new String[0]);
        op.add(Builder::minTermFreq, JsonpDeserializer.integerDeserializer(), "min_term_freq", new String[0]);
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length", new String[0]);
        op.add(Builder::perFieldAnalyzer, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "per_field_analyzer", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::stopWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stop_words", new String[0]);
        op.add(Builder::unlike, JsonpDeserializer.arrayDeserializer(LikeDocument._DESERIALIZER), "unlike", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MoreLikeThisQuery> {
        @Nullable
        private String analyzer;
        @Nullable
        private Double boostTerms;
        @Nullable
        private Boolean failOnUnsupportedField;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean include;
        private List<LikeDocument> like;
        @Nullable
        private Integer maxDocFreq;
        @Nullable
        private Integer maxQueryTerms;
        @Nullable
        private Integer maxWordLength;
        @Nullable
        private Integer minDocFreq;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private Integer minTermFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private Map<String, String> perFieldAnalyzer;
        @Nullable
        private String routing;
        @Nullable
        private List<String> stopWords;
        @Nullable
        private List<LikeDocument> unlike;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder boostTerms(@Nullable Double value) {
            this.boostTerms = value;
            return this;
        }

        public Builder failOnUnsupportedField(@Nullable Boolean value) {
            this.failOnUnsupportedField = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder include(@Nullable Boolean value) {
            this.include = value;
            return this;
        }

        public Builder like(List<LikeDocument> value) {
            this.like = value;
            return this;
        }

        public Builder like(LikeDocument ... value) {
            this.like = Arrays.asList(value);
            return this;
        }

        public Builder addLike(LikeDocument value) {
            if (this.like == null) {
                this.like = new ArrayList<LikeDocument>();
            }
            this.like.add(value);
            return this;
        }

        public Builder like(Function<LikeDocument.Builder, ObjectBuilder<LikeDocument>> fn) {
            return this.like(fn.apply(new LikeDocument.Builder()).build());
        }

        public Builder addLike(Function<LikeDocument.Builder, ObjectBuilder<LikeDocument>> fn) {
            return this.addLike(fn.apply(new LikeDocument.Builder()).build());
        }

        public Builder maxDocFreq(@Nullable Integer value) {
            this.maxDocFreq = value;
            return this;
        }

        public Builder maxQueryTerms(@Nullable Integer value) {
            this.maxQueryTerms = value;
            return this;
        }

        public Builder maxWordLength(@Nullable Integer value) {
            this.maxWordLength = value;
            return this;
        }

        public Builder minDocFreq(@Nullable Integer value) {
            this.minDocFreq = value;
            return this;
        }

        public Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public Builder minTermFreq(@Nullable Integer value) {
            this.minTermFreq = value;
            return this;
        }

        public Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        public Builder perFieldAnalyzer(@Nullable Map<String, String> value) {
            this.perFieldAnalyzer = value;
            return this;
        }

        public Builder putPerFieldAnalyzer(String key, String value) {
            if (this.perFieldAnalyzer == null) {
                this.perFieldAnalyzer = new HashMap<String, String>();
            }
            this.perFieldAnalyzer.put(key, value);
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder stopWords(@Nullable List<String> value) {
            this.stopWords = value;
            return this;
        }

        public Builder stopWords(String ... value) {
            this.stopWords = Arrays.asList(value);
            return this;
        }

        public Builder addStopWords(String value) {
            if (this.stopWords == null) {
                this.stopWords = new ArrayList<String>();
            }
            this.stopWords.add(value);
            return this;
        }

        public Builder unlike(@Nullable List<LikeDocument> value) {
            this.unlike = value;
            return this;
        }

        public Builder unlike(LikeDocument ... value) {
            this.unlike = Arrays.asList(value);
            return this;
        }

        public Builder addUnlike(LikeDocument value) {
            if (this.unlike == null) {
                this.unlike = new ArrayList<LikeDocument>();
            }
            this.unlike.add(value);
            return this;
        }

        public Builder unlike(Function<LikeDocument.Builder, ObjectBuilder<LikeDocument>> fn) {
            return this.unlike(fn.apply(new LikeDocument.Builder()).build());
        }

        public Builder addUnlike(Function<LikeDocument.Builder, ObjectBuilder<LikeDocument>> fn) {
            return this.addUnlike(fn.apply(new LikeDocument.Builder()).build());
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MoreLikeThisQuery build() {
            return new MoreLikeThisQuery(this);
        }
    }
}

