/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.ZeroTermsQuery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MatchPhraseQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final String analyzer;
    private final String query;
    @Nullable
    private final Integer slop;
    @Nullable
    private final ZeroTermsQuery zeroTermsQuery;
    public static final JsonpDeserializer<MatchPhraseQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatchPhraseQuery::setupMatchPhraseQueryDeserializer, Builder::build);

    public MatchPhraseQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.analyzer = builder.analyzer;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.slop = builder.slop;
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public MatchPhraseQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "match_phrase";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public Integer slop() {
        return this.slop;
    }

    @Nullable
    public ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.slop != null) {
            generator.writeKey("slop");
            generator.write(this.slop.intValue());
        }
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupMatchPhraseQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::slop, JsonpDeserializer.integerDeserializer(), "slop", new String[0]);
        op.add(Builder::zeroTermsQuery, ZeroTermsQuery._DESERIALIZER, "zero_terms_query", new String[0]);
        op.setKey(Builder::field);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MatchPhraseQuery> {
        private String field;
        @Nullable
        private String analyzer;
        private String query;
        @Nullable
        private Integer slop;
        @Nullable
        private ZeroTermsQuery zeroTermsQuery;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder slop(@Nullable Integer value) {
            this.slop = value;
            return this;
        }

        public Builder zeroTermsQuery(@Nullable ZeroTermsQuery value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MatchPhraseQuery build() {
            return new MatchPhraseQuery(this);
        }
    }
}

