/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IdsQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final List<String> values;
    public static final JsonpDeserializer<IdsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IdsQuery::setupIdsQueryDeserializer, Builder::build);

    public IdsQuery(Builder builder) {
        super(builder);
        this.values = ModelTypeHelper.unmodifiable(builder.values);
    }

    public IdsQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "ids";
    }

    @Nullable
    public List<String> values() {
        return this.values;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.values != null) {
            generator.writeKey("values");
            generator.writeStartArray();
            for (String item0 : this.values) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIdsQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::values, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "values", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IdsQuery> {
        @Nullable
        private List<String> values;

        public Builder values(@Nullable List<String> value) {
            this.values = value;
            return this;
        }

        public Builder values(String ... value) {
            this.values = Arrays.asList(value);
            return this;
        }

        public Builder addValues(String value) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IdsQuery build() {
            return new IdsQuery(this);
        }
    }
}

