/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TextIndexPrefixes
implements JsonpSerializable {
    private final int maxChars;
    private final int minChars;
    public static final JsonpDeserializer<TextIndexPrefixes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextIndexPrefixes::setupTextIndexPrefixesDeserializer, Builder::build);

    public TextIndexPrefixes(Builder builder) {
        this.maxChars = Objects.requireNonNull(builder.maxChars, "max_chars");
        this.minChars = Objects.requireNonNull(builder.minChars, "min_chars");
    }

    public TextIndexPrefixes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int maxChars() {
        return this.maxChars;
    }

    public int minChars() {
        return this.minChars;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_chars");
        generator.write(this.maxChars);
        generator.writeKey("min_chars");
        generator.write(this.minChars);
    }

    protected static void setupTextIndexPrefixesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxChars, JsonpDeserializer.integerDeserializer(), "max_chars", new String[0]);
        op.add(Builder::minChars, JsonpDeserializer.integerDeserializer(), "min_chars", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TextIndexPrefixes> {
        private Integer maxChars;
        private Integer minChars;

        public Builder maxChars(int value) {
            this.maxChars = value;
            return this;
        }

        public Builder minChars(int value) {
            this.minChars = value;
            return this;
        }

        @Override
        public TextIndexPrefixes build() {
            return new TextIndexPrefixes(this);
        }
    }
}

