/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch.indices.NumericFielddata;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NumberProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final NumericFielddata fielddata;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Double nullValue;
    @Nullable
    private final Double scalingFactor;
    public static final JsonpDeserializer<NumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NumberProperty::setupNumberPropertyDeserializer, Builder::build);

    public NumberProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.coerce = builder.coerce;
        this.fielddata = builder.fielddata;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
        this.scalingFactor = builder.scalingFactor;
    }

    public NumberProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "float";
    }

    @Nullable
    public Double boost() {
        return this.boost;
    }

    @Nullable
    public Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public NumericFielddata fielddata() {
        return this.fielddata;
    }

    @Nullable
    public Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Nullable
    public Double nullValue() {
        return this.nullValue;
    }

    @Nullable
    public Double scalingFactor() {
        return this.scalingFactor;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "float");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.fielddata != null) {
            generator.writeKey("fielddata");
            this.fielddata.serialize(generator, mapper);
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
        if (this.scalingFactor != null) {
            generator.writeKey("scaling_factor");
            generator.write(this.scalingFactor.doubleValue());
        }
    }

    protected static void setupNumberPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(Builder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce", new String[0]);
        op.add(Builder::fielddata, NumericFielddata._DESERIALIZER, "fielddata", new String[0]);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed", new String[0]);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
        op.add(Builder::nullValue, JsonpDeserializer.doubleDeserializer(), "null_value", new String[0]);
        op.add(Builder::scalingFactor, JsonpDeserializer.doubleDeserializer(), "scaling_factor", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NumberProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean coerce;
        @Nullable
        private NumericFielddata fielddata;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean index;
        @Nullable
        private Double nullValue;
        @Nullable
        private Double scalingFactor;

        public Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public Builder coerce(@Nullable Boolean value) {
            this.coerce = value;
            return this;
        }

        public Builder fielddata(@Nullable NumericFielddata value) {
            this.fielddata = value;
            return this;
        }

        public Builder fielddata(Function<NumericFielddata.Builder, ObjectBuilder<NumericFielddata>> fn) {
            return this.fielddata(fn.apply(new NumericFielddata.Builder()).build());
        }

        public Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public Builder nullValue(@Nullable Double value) {
            this.nullValue = value;
            return this;
        }

        public Builder scalingFactor(@Nullable Double value) {
            this.scalingFactor = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NumberProperty build() {
            return new NumberProperty(this);
        }
    }
}

