/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NestedProperty
extends CorePropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Boolean includeInParent;
    @Nullable
    private final Boolean includeInRoot;
    public static final JsonpDeserializer<NestedProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedProperty::setupNestedPropertyDeserializer, Builder::build);

    public NestedProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.includeInParent = builder.includeInParent;
        this.includeInRoot = builder.includeInRoot;
    }

    public NestedProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "nested";
    }

    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public Boolean includeInParent() {
        return this.includeInParent;
    }

    @Nullable
    public Boolean includeInRoot() {
        return this.includeInRoot;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nested");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.includeInParent != null) {
            generator.writeKey("include_in_parent");
            generator.write(this.includeInParent.booleanValue());
        }
        if (this.includeInRoot != null) {
            generator.writeKey("include_in_root");
            generator.write(this.includeInRoot.booleanValue());
        }
    }

    protected static void setupNestedPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
        op.add(Builder::includeInParent, JsonpDeserializer.booleanDeserializer(), "include_in_parent", new String[0]);
        op.add(Builder::includeInRoot, JsonpDeserializer.booleanDeserializer(), "include_in_root", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NestedProperty> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private Boolean includeInParent;
        @Nullable
        private Boolean includeInRoot;

        public Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder includeInParent(@Nullable Boolean value) {
            this.includeInParent = value;
            return this;
        }

        public Builder includeInRoot(@Nullable Boolean value) {
            this.includeInRoot = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NestedProperty build() {
            return new NestedProperty(this);
        }
    }
}

