/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.GeoOrientation;
import co.elastic.clients.elasticsearch._types.mapping.GeoStrategy;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoShapeProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean ignoreZValue;
    @Nullable
    private final GeoOrientation orientation;
    @Nullable
    private final GeoStrategy strategy;
    public static final JsonpDeserializer<GeoShapeProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoShapeProperty::setupGeoShapePropertyDeserializer, Builder::build);

    public GeoShapeProperty(Builder builder) {
        super(builder);
        this.coerce = builder.coerce;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.ignoreZValue = builder.ignoreZValue;
        this.orientation = builder.orientation;
        this.strategy = builder.strategy;
    }

    public GeoShapeProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_shape";
    }

    @Nullable
    public Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public Boolean ignoreZValue() {
        return this.ignoreZValue;
    }

    @Nullable
    public GeoOrientation orientation() {
        return this.orientation;
    }

    @Nullable
    public GeoStrategy strategy() {
        return this.strategy;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "geo_shape");
        super.serializeInternal(generator, mapper);
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.ignoreZValue != null) {
            generator.writeKey("ignore_z_value");
            generator.write(this.ignoreZValue.booleanValue());
        }
        if (this.orientation != null) {
            generator.writeKey("orientation");
            this.orientation.serialize(generator, mapper);
        }
        if (this.strategy != null) {
            generator.writeKey("strategy");
            this.strategy.serialize(generator, mapper);
        }
    }

    protected static void setupGeoShapePropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce", new String[0]);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed", new String[0]);
        op.add(Builder::ignoreZValue, JsonpDeserializer.booleanDeserializer(), "ignore_z_value", new String[0]);
        op.add(Builder::orientation, GeoOrientation._DESERIALIZER, "orientation", new String[0]);
        op.add(Builder::strategy, GeoStrategy._DESERIALIZER, "strategy", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoShapeProperty> {
        @Nullable
        private Boolean coerce;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean ignoreZValue;
        @Nullable
        private GeoOrientation orientation;
        @Nullable
        private GeoStrategy strategy;

        public Builder coerce(@Nullable Boolean value) {
            this.coerce = value;
            return this;
        }

        public Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public Builder ignoreZValue(@Nullable Boolean value) {
            this.ignoreZValue = value;
            return this;
        }

        public Builder orientation(@Nullable GeoOrientation value) {
            this.orientation = value;
            return this;
        }

        public Builder strategy(@Nullable GeoStrategy value) {
            this.strategy = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoShapeProperty build() {
            return new GeoShapeProperty(this);
        }
    }
}

