/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DenseVectorProperty
extends PropertyBase
implements PropertyVariant {
    private final int dims;
    public static final JsonpDeserializer<DenseVectorProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorProperty::setupDenseVectorPropertyDeserializer, Builder::build);

    public DenseVectorProperty(Builder builder) {
        super(builder);
        this.dims = Objects.requireNonNull(builder.dims, "dims");
    }

    public DenseVectorProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "dense_vector";
    }

    public int dims() {
        return this.dims;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "dense_vector");
        super.serializeInternal(generator, mapper);
        generator.writeKey("dims");
        generator.write(this.dims);
    }

    protected static void setupDenseVectorPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::dims, JsonpDeserializer.integerDeserializer(), "dims", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DenseVectorProperty> {
        private Integer dims;

        public Builder dims(int value) {
            this.dims = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorProperty build() {
            return new DenseVectorProperty(this);
        }
    }
}

