/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DateNanosProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean index;
    @Nullable
    private final String nullValue;
    @Nullable
    private final Integer precisionStep;
    public static final JsonpDeserializer<DateNanosProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateNanosProperty::setupDateNanosPropertyDeserializer, Builder::build);

    public DateNanosProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.format = builder.format;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
        this.precisionStep = builder.precisionStep;
    }

    public DateNanosProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "date_nanos";
    }

    @Nullable
    public Double boost() {
        return this.boost;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Nullable
    public String nullValue() {
        return this.nullValue;
    }

    @Nullable
    public Integer precisionStep() {
        return this.precisionStep;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "date_nanos");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
        if (this.precisionStep != null) {
            generator.writeKey("precision_step");
            generator.write(this.precisionStep.intValue());
        }
    }

    protected static void setupDateNanosPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed", new String[0]);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value", new String[0]);
        op.add(Builder::precisionStep, JsonpDeserializer.integerDeserializer(), "precision_step", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateNanosProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private String format;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean index;
        @Nullable
        private String nullValue;
        @Nullable
        private Integer precisionStep;

        public Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        public Builder precisionStep(@Nullable Integer value) {
            this.precisionStep = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateNanosProperty build() {
            return new DateNanosProperty(this);
        }
    }
}

