/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ConstantKeywordProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final JsonData value;
    public static final JsonpDeserializer<ConstantKeywordProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConstantKeywordProperty::setupConstantKeywordPropertyDeserializer, Builder::build);

    public ConstantKeywordProperty(Builder builder) {
        super(builder);
        this.value = builder.value;
    }

    public ConstantKeywordProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "constant_keyword";
    }

    @Nullable
    public JsonData value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "constant_keyword");
        super.serializeInternal(generator, mapper);
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
    }

    protected static void setupConstantKeywordPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::value, JsonData._DESERIALIZER, "value", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ConstantKeywordProperty> {
        @Nullable
        private JsonData value;

        public Builder value(@Nullable JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConstantKeywordProperty build() {
            return new ConstantKeywordProperty(this);
        }
    }
}

