/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.SynonymFormat;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SynonymTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean expand;
    private final SynonymFormat format;
    private final boolean lenient;
    private final List<String> synonyms;
    private final String synonymsPath;
    private final String tokenizer;
    private final boolean updateable;
    public static final JsonpDeserializer<SynonymTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SynonymTokenFilter::setupSynonymTokenFilterDeserializer, Builder::build);

    public SynonymTokenFilter(Builder builder) {
        super(builder);
        this.expand = Objects.requireNonNull(builder.expand, "expand");
        this.format = Objects.requireNonNull(builder.format, "format");
        this.lenient = Objects.requireNonNull(builder.lenient, "lenient");
        this.synonyms = ModelTypeHelper.unmodifiableNonNull(builder.synonyms, "synonyms");
        this.synonymsPath = Objects.requireNonNull(builder.synonymsPath, "synonyms_path");
        this.tokenizer = Objects.requireNonNull(builder.tokenizer, "tokenizer");
        this.updateable = Objects.requireNonNull(builder.updateable, "updateable");
    }

    public SynonymTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "synonym";
    }

    public boolean expand() {
        return this.expand;
    }

    public SynonymFormat format() {
        return this.format;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public List<String> synonyms() {
        return this.synonyms;
    }

    public String synonymsPath() {
        return this.synonymsPath;
    }

    public String tokenizer() {
        return this.tokenizer;
    }

    public boolean updateable() {
        return this.updateable;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "synonym");
        super.serializeInternal(generator, mapper);
        generator.writeKey("expand");
        generator.write(this.expand);
        generator.writeKey("format");
        this.format.serialize(generator, mapper);
        generator.writeKey("lenient");
        generator.write(this.lenient);
        generator.writeKey("synonyms");
        generator.writeStartArray();
        for (String item0 : this.synonyms) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("synonyms_path");
        generator.write(this.synonymsPath);
        generator.writeKey("tokenizer");
        generator.write(this.tokenizer);
        generator.writeKey("updateable");
        generator.write(this.updateable);
    }

    protected static void setupSynonymTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::expand, JsonpDeserializer.booleanDeserializer(), "expand", new String[0]);
        op.add(Builder::format, SynonymFormat._DESERIALIZER, "format", new String[0]);
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient", new String[0]);
        op.add(Builder::synonyms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "synonyms", new String[0]);
        op.add(Builder::synonymsPath, JsonpDeserializer.stringDeserializer(), "synonyms_path", new String[0]);
        op.add(Builder::tokenizer, JsonpDeserializer.stringDeserializer(), "tokenizer", new String[0]);
        op.add(Builder::updateable, JsonpDeserializer.booleanDeserializer(), "updateable", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SynonymTokenFilter> {
        private Boolean expand;
        private SynonymFormat format;
        private Boolean lenient;
        private List<String> synonyms;
        private String synonymsPath;
        private String tokenizer;
        private Boolean updateable;

        public Builder expand(boolean value) {
            this.expand = value;
            return this;
        }

        public Builder format(SynonymFormat value) {
            this.format = value;
            return this;
        }

        public Builder lenient(boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder synonyms(List<String> value) {
            this.synonyms = value;
            return this;
        }

        public Builder synonyms(String ... value) {
            this.synonyms = Arrays.asList(value);
            return this;
        }

        public Builder addSynonyms(String value) {
            if (this.synonyms == null) {
                this.synonyms = new ArrayList<String>();
            }
            this.synonyms.add(value);
            return this;
        }

        public Builder synonymsPath(String value) {
            this.synonymsPath = value;
            return this;
        }

        public Builder tokenizer(String value) {
            this.tokenizer = value;
            return this;
        }

        public Builder updateable(boolean value) {
            this.updateable = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SynonymTokenFilter build() {
            return new SynonymTokenFilter(this);
        }
    }
}

