/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.SnowballLanguage;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SnowballTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final SnowballLanguage language;
    public static final JsonpDeserializer<SnowballTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnowballTokenFilter::setupSnowballTokenFilterDeserializer, Builder::build);

    public SnowballTokenFilter(Builder builder) {
        super(builder);
        this.language = Objects.requireNonNull(builder.language, "language");
    }

    public SnowballTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "snowball";
    }

    public SnowballLanguage language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "snowball");
        super.serializeInternal(generator, mapper);
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
    }

    protected static void setupSnowballTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, SnowballLanguage._DESERIALIZER, "language", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SnowballTokenFilter> {
        private SnowballLanguage language;

        public Builder language(SnowballLanguage value) {
            this.language = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnowballTokenFilter build() {
            return new SnowballTokenFilter(this);
        }
    }
}

