/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenChar;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NGramTokenizer
extends TokenizerBase
implements TokenizerVariant {
    private final String customTokenChars;
    private final int maxGram;
    private final int minGram;
    private final List<TokenChar> tokenChars;
    public static final JsonpDeserializer<NGramTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NGramTokenizer::setupNGramTokenizerDeserializer, Builder::build);

    public NGramTokenizer(Builder builder) {
        super(builder);
        this.customTokenChars = Objects.requireNonNull(builder.customTokenChars, "custom_token_chars");
        this.maxGram = Objects.requireNonNull(builder.maxGram, "max_gram");
        this.minGram = Objects.requireNonNull(builder.minGram, "min_gram");
        this.tokenChars = ModelTypeHelper.unmodifiableNonNull(builder.tokenChars, "token_chars");
    }

    public NGramTokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "ngram";
    }

    public String customTokenChars() {
        return this.customTokenChars;
    }

    public int maxGram() {
        return this.maxGram;
    }

    public int minGram() {
        return this.minGram;
    }

    public List<TokenChar> tokenChars() {
        return this.tokenChars;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ngram");
        super.serializeInternal(generator, mapper);
        generator.writeKey("custom_token_chars");
        generator.write(this.customTokenChars);
        generator.writeKey("max_gram");
        generator.write(this.maxGram);
        generator.writeKey("min_gram");
        generator.write(this.minGram);
        generator.writeKey("token_chars");
        generator.writeStartArray();
        for (TokenChar item0 : this.tokenChars) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupNGramTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::customTokenChars, JsonpDeserializer.stringDeserializer(), "custom_token_chars", new String[0]);
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram", new String[0]);
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram", new String[0]);
        op.add(Builder::tokenChars, JsonpDeserializer.arrayDeserializer(TokenChar._DESERIALIZER), "token_chars", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NGramTokenizer> {
        private String customTokenChars;
        private Integer maxGram;
        private Integer minGram;
        private List<TokenChar> tokenChars;

        public Builder customTokenChars(String value) {
            this.customTokenChars = value;
            return this;
        }

        public Builder maxGram(int value) {
            this.maxGram = value;
            return this;
        }

        public Builder minGram(int value) {
            this.minGram = value;
            return this;
        }

        public Builder tokenChars(List<TokenChar> value) {
            this.tokenChars = value;
            return this;
        }

        public Builder tokenChars(TokenChar ... value) {
            this.tokenChars = Arrays.asList(value);
            return this;
        }

        public Builder addTokenChars(TokenChar value) {
            if (this.tokenChars == null) {
                this.tokenChars = new ArrayList<TokenChar>();
            }
            this.tokenChars.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NGramTokenizer build() {
            return new NGramTokenizer(this);
        }
    }
}

