/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.CharFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MappingCharFilter
extends CharFilterBase
implements CharFilterVariant {
    private final List<String> mappings;
    private final String mappingsPath;
    public static final JsonpDeserializer<MappingCharFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MappingCharFilter::setupMappingCharFilterDeserializer, Builder::build);

    public MappingCharFilter(Builder builder) {
        super(builder);
        this.mappings = ModelTypeHelper.unmodifiableNonNull(builder.mappings, "mappings");
        this.mappingsPath = Objects.requireNonNull(builder.mappingsPath, "mappings_path");
    }

    public MappingCharFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "mapping";
    }

    public List<String> mappings() {
        return this.mappings;
    }

    public String mappingsPath() {
        return this.mappingsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "mapping");
        super.serializeInternal(generator, mapper);
        generator.writeKey("mappings");
        generator.writeStartArray();
        for (String item0 : this.mappings) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("mappings_path");
        generator.write(this.mappingsPath);
    }

    protected static void setupMappingCharFilterDeserializer(DelegatingDeserializer<Builder> op) {
        CharFilterBase.setupCharFilterBaseDeserializer(op);
        op.add(Builder::mappings, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "mappings", new String[0]);
        op.add(Builder::mappingsPath, JsonpDeserializer.stringDeserializer(), "mappings_path", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends CharFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MappingCharFilter> {
        private List<String> mappings;
        private String mappingsPath;

        public Builder mappings(List<String> value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(String ... value) {
            this.mappings = Arrays.asList(value);
            return this;
        }

        public Builder addMappings(String value) {
            if (this.mappings == null) {
                this.mappings = new ArrayList<String>();
            }
            this.mappings.add(value);
            return this;
        }

        public Builder mappingsPath(String value) {
            this.mappingsPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MappingCharFilter build() {
            return new MappingCharFilter(this);
        }
    }
}

