/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.ChiSquareHeuristic;
import co.elastic.clients.elasticsearch._types.aggregations.GoogleNormalizedDistanceHeuristic;
import co.elastic.clients.elasticsearch._types.aggregations.MutualInformationHeuristic;
import co.elastic.clients.elasticsearch._types.aggregations.PercentageScoreHeuristic;
import co.elastic.clients.elasticsearch._types.aggregations.ScriptedHeuristic;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregationExecutionHint;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SignificantTermsAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final Query backgroundFilter;
    @Nullable
    private final ChiSquareHeuristic chiSquare;
    @Nullable
    private final List<String> exclude;
    @Nullable
    private final TermsAggregationExecutionHint executionHint;
    @Nullable
    private final String field;
    @Nullable
    private final GoogleNormalizedDistanceHeuristic gnd;
    @Nullable
    private final List<String> include;
    @Nullable
    private final Long minDocCount;
    @Nullable
    private final MutualInformationHeuristic mutualInformation;
    @Nullable
    private final PercentageScoreHeuristic percentage;
    @Nullable
    private final ScriptedHeuristic scriptHeuristic;
    @Nullable
    private final Long shardMinDocCount;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<SignificantTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SignificantTermsAggregation::setupSignificantTermsAggregationDeserializer, Builder::build);

    public SignificantTermsAggregation(Builder builder) {
        super(builder);
        this.backgroundFilter = builder.backgroundFilter;
        this.chiSquare = builder.chiSquare;
        this.exclude = ModelTypeHelper.unmodifiable(builder.exclude);
        this.executionHint = builder.executionHint;
        this.field = builder.field;
        this.gnd = builder.gnd;
        this.include = ModelTypeHelper.unmodifiable(builder.include);
        this.minDocCount = builder.minDocCount;
        this.mutualInformation = builder.mutualInformation;
        this.percentage = builder.percentage;
        this.scriptHeuristic = builder.scriptHeuristic;
        this.shardMinDocCount = builder.shardMinDocCount;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
    }

    public SignificantTermsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "significant_terms";
    }

    @Nullable
    public Query backgroundFilter() {
        return this.backgroundFilter;
    }

    @Nullable
    public ChiSquareHeuristic chiSquare() {
        return this.chiSquare;
    }

    @Nullable
    public List<String> exclude() {
        return this.exclude;
    }

    @Nullable
    public TermsAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public GoogleNormalizedDistanceHeuristic gnd() {
        return this.gnd;
    }

    @Nullable
    public List<String> include() {
        return this.include;
    }

    @Nullable
    public Long minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public MutualInformationHeuristic mutualInformation() {
        return this.mutualInformation;
    }

    @Nullable
    public PercentageScoreHeuristic percentage() {
        return this.percentage;
    }

    @Nullable
    public ScriptedHeuristic scriptHeuristic() {
        return this.scriptHeuristic;
    }

    @Nullable
    public Long shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Nullable
    public Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.backgroundFilter != null) {
            generator.writeKey("background_filter");
            this.backgroundFilter.serialize(generator, mapper);
        }
        if (this.chiSquare != null) {
            generator.writeKey("chi_square");
            this.chiSquare.serialize(generator, mapper);
        }
        if (this.exclude != null) {
            generator.writeKey("exclude");
            generator.writeStartArray();
            for (String item0 : this.exclude) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.gnd != null) {
            generator.writeKey("gnd");
            this.gnd.serialize(generator, mapper);
        }
        if (this.include != null) {
            generator.writeKey("include");
            generator.writeStartArray();
            for (String item0 : this.include) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.longValue());
        }
        if (this.mutualInformation != null) {
            generator.writeKey("mutual_information");
            this.mutualInformation.serialize(generator, mapper);
        }
        if (this.percentage != null) {
            generator.writeKey("percentage");
            this.percentage.serialize(generator, mapper);
        }
        if (this.scriptHeuristic != null) {
            generator.writeKey("script_heuristic");
            this.scriptHeuristic.serialize(generator, mapper);
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount.longValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupSignificantTermsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::backgroundFilter, Query._DESERIALIZER, "background_filter", new String[0]);
        op.add(Builder::chiSquare, ChiSquareHeuristic._DESERIALIZER, "chi_square", new String[0]);
        op.add(Builder::exclude, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude", new String[0]);
        op.add(Builder::executionHint, TermsAggregationExecutionHint._DESERIALIZER, "execution_hint", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::gnd, GoogleNormalizedDistanceHeuristic._DESERIALIZER, "gnd", new String[0]);
        op.add(Builder::include, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "include", new String[0]);
        op.add(Builder::minDocCount, JsonpDeserializer.longDeserializer(), "min_doc_count", new String[0]);
        op.add(Builder::mutualInformation, MutualInformationHeuristic._DESERIALIZER, "mutual_information", new String[0]);
        op.add(Builder::percentage, PercentageScoreHeuristic._DESERIALIZER, "percentage", new String[0]);
        op.add(Builder::scriptHeuristic, ScriptedHeuristic._DESERIALIZER, "script_heuristic", new String[0]);
        op.add(Builder::shardMinDocCount, JsonpDeserializer.longDeserializer(), "shard_min_doc_count", new String[0]);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SignificantTermsAggregation> {
        @Nullable
        private Query backgroundFilter;
        @Nullable
        private ChiSquareHeuristic chiSquare;
        @Nullable
        private List<String> exclude;
        @Nullable
        private TermsAggregationExecutionHint executionHint;
        @Nullable
        private String field;
        @Nullable
        private GoogleNormalizedDistanceHeuristic gnd;
        @Nullable
        private List<String> include;
        @Nullable
        private Long minDocCount;
        @Nullable
        private MutualInformationHeuristic mutualInformation;
        @Nullable
        private PercentageScoreHeuristic percentage;
        @Nullable
        private ScriptedHeuristic scriptHeuristic;
        @Nullable
        private Long shardMinDocCount;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;

        public Builder backgroundFilter(@Nullable Query value) {
            this.backgroundFilter = value;
            return this;
        }

        public Builder backgroundFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.backgroundFilter(fn.apply(new Query.Builder()).build());
        }

        public Builder chiSquare(@Nullable ChiSquareHeuristic value) {
            this.chiSquare = value;
            return this;
        }

        public Builder chiSquare(Function<ChiSquareHeuristic.Builder, ObjectBuilder<ChiSquareHeuristic>> fn) {
            return this.chiSquare(fn.apply(new ChiSquareHeuristic.Builder()).build());
        }

        public Builder exclude(@Nullable List<String> value) {
            this.exclude = value;
            return this;
        }

        public Builder exclude(String ... value) {
            this.exclude = Arrays.asList(value);
            return this;
        }

        public Builder addExclude(String value) {
            if (this.exclude == null) {
                this.exclude = new ArrayList<String>();
            }
            this.exclude.add(value);
            return this;
        }

        public Builder executionHint(@Nullable TermsAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder gnd(@Nullable GoogleNormalizedDistanceHeuristic value) {
            this.gnd = value;
            return this;
        }

        public Builder gnd(Function<GoogleNormalizedDistanceHeuristic.Builder, ObjectBuilder<GoogleNormalizedDistanceHeuristic>> fn) {
            return this.gnd(fn.apply(new GoogleNormalizedDistanceHeuristic.Builder()).build());
        }

        public Builder include(@Nullable List<String> value) {
            this.include = value;
            return this;
        }

        public Builder include(String ... value) {
            this.include = Arrays.asList(value);
            return this;
        }

        public Builder addInclude(String value) {
            if (this.include == null) {
                this.include = new ArrayList<String>();
            }
            this.include.add(value);
            return this;
        }

        public Builder minDocCount(@Nullable Long value) {
            this.minDocCount = value;
            return this;
        }

        public Builder mutualInformation(@Nullable MutualInformationHeuristic value) {
            this.mutualInformation = value;
            return this;
        }

        public Builder mutualInformation(Function<MutualInformationHeuristic.Builder, ObjectBuilder<MutualInformationHeuristic>> fn) {
            return this.mutualInformation(fn.apply(new MutualInformationHeuristic.Builder()).build());
        }

        public Builder percentage(@Nullable PercentageScoreHeuristic value) {
            this.percentage = value;
            return this;
        }

        public Builder percentage(Function<PercentageScoreHeuristic.Builder, ObjectBuilder<PercentageScoreHeuristic>> fn) {
            return this.percentage(fn.apply(new PercentageScoreHeuristic.Builder()).build());
        }

        public Builder scriptHeuristic(@Nullable ScriptedHeuristic value) {
            this.scriptHeuristic = value;
            return this;
        }

        public Builder scriptHeuristic(Function<ScriptedHeuristic.Builder, ObjectBuilder<ScriptedHeuristic>> fn) {
            return this.scriptHeuristic(fn.apply(new ScriptedHeuristic.Builder()).build());
        }

        public Builder shardMinDocCount(@Nullable Long value) {
            this.shardMinDocCount = value;
            return this;
        }

        public Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SignificantTermsAggregation build() {
            return new SignificantTermsAggregation(this);
        }
    }
}

