/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RegressionInferenceOptions
implements JsonpSerializable {
    @Nullable
    private final String resultsField;
    @Nullable
    private final Integer numTopFeatureImportanceValues;
    public static final JsonpDeserializer<RegressionInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RegressionInferenceOptions::setupRegressionInferenceOptionsDeserializer, Builder::build);

    public RegressionInferenceOptions(Builder builder) {
        this.resultsField = builder.resultsField;
        this.numTopFeatureImportanceValues = builder.numTopFeatureImportanceValues;
    }

    public RegressionInferenceOptions(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public Integer numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            generator.writeKey("num_top_feature_importance_values");
            generator.write(this.numTopFeatureImportanceValues.intValue());
        }
    }

    protected static void setupRegressionInferenceOptionsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field", new String[0]);
        op.add(Builder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RegressionInferenceOptions> {
        @Nullable
        private String resultsField;
        @Nullable
        private Integer numTopFeatureImportanceValues;

        public Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public Builder numTopFeatureImportanceValues(@Nullable Integer value) {
            this.numTopFeatureImportanceValues = value;
            return this;
        }

        @Override
        public RegressionInferenceOptions build() {
            return new RegressionInferenceOptions(this);
        }
    }
}

