/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RareTermsAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final List<String> exclude;
    @Nullable
    private final String field;
    @Nullable
    private final JsonValue include;
    @Nullable
    private final Long maxDocCount;
    @Nullable
    private final String missing;
    @Nullable
    private final Double precision;
    @Nullable
    private final String valueType;
    public static final JsonpDeserializer<RareTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RareTermsAggregation::setupRareTermsAggregationDeserializer, Builder::build);

    public RareTermsAggregation(Builder builder) {
        super(builder);
        this.exclude = ModelTypeHelper.unmodifiable(builder.exclude);
        this.field = builder.field;
        this.include = builder.include;
        this.maxDocCount = builder.maxDocCount;
        this.missing = builder.missing;
        this.precision = builder.precision;
        this.valueType = builder.valueType;
    }

    public RareTermsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "rare_terms";
    }

    @Nullable
    public List<String> exclude() {
        return this.exclude;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public JsonValue include() {
        return this.include;
    }

    @Nullable
    public Long maxDocCount() {
        return this.maxDocCount;
    }

    @Nullable
    public String missing() {
        return this.missing;
    }

    @Nullable
    public Double precision() {
        return this.precision;
    }

    @Nullable
    public String valueType() {
        return this.valueType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.exclude != null) {
            generator.writeKey("exclude");
            generator.writeStartArray();
            for (String item0 : this.exclude) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.include != null) {
            generator.writeKey("include");
            generator.write(this.include);
        }
        if (this.maxDocCount != null) {
            generator.writeKey("max_doc_count");
            generator.write(this.maxDocCount.longValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.doubleValue());
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            generator.write(this.valueType);
        }
    }

    protected static void setupRareTermsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::exclude, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::include, JsonpDeserializer.jsonValueDeserializer(), "include", new String[0]);
        op.add(Builder::maxDocCount, JsonpDeserializer.longDeserializer(), "max_doc_count", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.stringDeserializer(), "missing", new String[0]);
        op.add(Builder::precision, JsonpDeserializer.doubleDeserializer(), "precision", new String[0]);
        op.add(Builder::valueType, JsonpDeserializer.stringDeserializer(), "value_type", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RareTermsAggregation> {
        @Nullable
        private List<String> exclude;
        @Nullable
        private String field;
        @Nullable
        private JsonValue include;
        @Nullable
        private Long maxDocCount;
        @Nullable
        private String missing;
        @Nullable
        private Double precision;
        @Nullable
        private String valueType;

        public Builder exclude(@Nullable List<String> value) {
            this.exclude = value;
            return this;
        }

        public Builder exclude(String ... value) {
            this.exclude = Arrays.asList(value);
            return this;
        }

        public Builder addExclude(String value) {
            if (this.exclude == null) {
                this.exclude = new ArrayList<String>();
            }
            this.exclude.add(value);
            return this;
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder include(@Nullable JsonValue value) {
            this.include = value;
            return this;
        }

        public Builder maxDocCount(@Nullable Long value) {
            this.maxDocCount = value;
            return this;
        }

        public Builder missing(@Nullable String value) {
            this.missing = value;
            return this;
        }

        public Builder precision(@Nullable Double value) {
            this.precision = value;
            return this;
        }

        public Builder valueType(@Nullable String value) {
            this.valueType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RareTermsAggregation build() {
            return new RareTermsAggregation(this);
        }
    }
}

