/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MutualInformationHeuristic
implements JsonpSerializable {
    private final boolean backgroundIsSuperset;
    private final boolean includeNegatives;
    public static final JsonpDeserializer<MutualInformationHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MutualInformationHeuristic::setupMutualInformationHeuristicDeserializer, Builder::build);

    public MutualInformationHeuristic(Builder builder) {
        this.backgroundIsSuperset = Objects.requireNonNull(builder.backgroundIsSuperset, "background_is_superset");
        this.includeNegatives = Objects.requireNonNull(builder.includeNegatives, "include_negatives");
    }

    public MutualInformationHeuristic(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean backgroundIsSuperset() {
        return this.backgroundIsSuperset;
    }

    public boolean includeNegatives() {
        return this.includeNegatives;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("background_is_superset");
        generator.write(this.backgroundIsSuperset);
        generator.writeKey("include_negatives");
        generator.write(this.includeNegatives);
    }

    protected static void setupMutualInformationHeuristicDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::backgroundIsSuperset, JsonpDeserializer.booleanDeserializer(), "background_is_superset", new String[0]);
        op.add(Builder::includeNegatives, JsonpDeserializer.booleanDeserializer(), "include_negatives", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MutualInformationHeuristic> {
        private Boolean backgroundIsSuperset;
        private Boolean includeNegatives;

        public Builder backgroundIsSuperset(boolean value) {
            this.backgroundIsSuperset = value;
            return this;
        }

        public Builder includeNegatives(boolean value) {
            this.includeNegatives = value;
            return this;
        }

        @Override
        public MutualInformationHeuristic build() {
            return new MutualInformationHeuristic(this);
        }
    }
}

