/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MovingPercentilesAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer window;
    @Nullable
    private final Integer shift;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<MovingPercentilesAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MovingPercentilesAggregation::setupMovingPercentilesAggregationDeserializer, Builder::build);

    public MovingPercentilesAggregation(Builder builder) {
        super(builder);
        this.window = builder.window;
        this.shift = builder.shift;
        this.keyed = builder.keyed;
    }

    public MovingPercentilesAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "moving_percentiles";
    }

    @Nullable
    public Integer window() {
        return this.window;
    }

    @Nullable
    public Integer shift() {
        return this.shift;
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.window != null) {
            generator.writeKey("window");
            generator.write(this.window.intValue());
        }
        if (this.shift != null) {
            generator.writeKey("shift");
            generator.write(this.shift.intValue());
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    protected static void setupMovingPercentilesAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::window, JsonpDeserializer.integerDeserializer(), "window", new String[0]);
        op.add(Builder::shift, JsonpDeserializer.integerDeserializer(), "shift", new String[0]);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MovingPercentilesAggregation> {
        @Nullable
        private Integer window;
        @Nullable
        private Integer shift;
        @Nullable
        private Boolean keyed;

        public Builder window(@Nullable Integer value) {
            this.window = value;
            return this;
        }

        public Builder shift(@Nullable Integer value) {
            this.shift = value;
            return this;
        }

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MovingPercentilesAggregation build() {
            return new MovingPercentilesAggregation(this);
        }
    }
}

