/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSourceVariant;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedBounds;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramOrder;
import co.elastic.clients.elasticsearch.transform.PivotGroupByVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HistogramAggregation
extends BucketAggregationBase
implements AggregationVariant,
PivotGroupByVariant,
CompositeAggregationSourceVariant {
    @Nullable
    private final ExtendedBounds<Double> extendedBounds;
    @Nullable
    private final ExtendedBounds<Double> hardBounds;
    @Nullable
    private final String field;
    @Nullable
    private final Double interval;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final Double missing;
    @Nullable
    private final Double offset;
    @Nullable
    private final HistogramOrder order;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<HistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramAggregation::setupHistogramAggregationDeserializer, Builder::build);

    public HistogramAggregation(Builder builder) {
        super(builder);
        this.extendedBounds = builder.extendedBounds;
        this.hardBounds = builder.hardBounds;
        this.field = builder.field;
        this.interval = builder.interval;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.offset = builder.offset;
        this.order = builder.order;
        this.script = builder.script;
        this.format = builder.format;
        this.keyed = builder.keyed;
    }

    public HistogramAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "histogram";
    }

    @Nullable
    public ExtendedBounds<Double> extendedBounds() {
        return this.extendedBounds;
    }

    @Nullable
    public ExtendedBounds<Double> hardBounds() {
        return this.hardBounds;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public Double interval() {
        return this.interval;
    }

    @Nullable
    public Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public Double missing() {
        return this.missing;
    }

    @Nullable
    public Double offset() {
        return this.offset;
    }

    @Nullable
    public HistogramOrder order() {
        return this.order;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.extendedBounds != null) {
            generator.writeKey("extended_bounds");
            this.extendedBounds.serialize(generator, mapper);
        }
        if (this.hardBounds != null) {
            generator.writeKey("hard_bounds");
            this.hardBounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            generator.write(this.interval.doubleValue());
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            generator.write(this.offset.doubleValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    protected static void setupHistogramAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::extendedBounds, ExtendedBounds.createExtendedBoundsDeserializer(JsonpDeserializer.doubleDeserializer()), "extended_bounds", new String[0]);
        op.add(Builder::hardBounds, ExtendedBounds.createExtendedBoundsDeserializer(JsonpDeserializer.doubleDeserializer()), "hard_bounds", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::interval, JsonpDeserializer.doubleDeserializer(), "interval", new String[0]);
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing", new String[0]);
        op.add(Builder::offset, JsonpDeserializer.doubleDeserializer(), "offset", new String[0]);
        op.add(Builder::order, HistogramOrder._DESERIALIZER, "order", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HistogramAggregation> {
        @Nullable
        private ExtendedBounds<Double> extendedBounds;
        @Nullable
        private ExtendedBounds<Double> hardBounds;
        @Nullable
        private String field;
        @Nullable
        private Double interval;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private Double missing;
        @Nullable
        private Double offset;
        @Nullable
        private HistogramOrder order;
        @Nullable
        private JsonValue script;
        @Nullable
        private String format;
        @Nullable
        private Boolean keyed;

        public Builder extendedBounds(@Nullable ExtendedBounds<Double> value) {
            this.extendedBounds = value;
            return this;
        }

        public Builder extendedBounds(Function<ExtendedBounds.Builder<Double>, ObjectBuilder<ExtendedBounds<Double>>> fn) {
            return this.extendedBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public Builder hardBounds(@Nullable ExtendedBounds<Double> value) {
            this.hardBounds = value;
            return this;
        }

        public Builder hardBounds(Function<ExtendedBounds.Builder<Double>, ObjectBuilder<ExtendedBounds<Double>>> fn) {
            return this.hardBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder interval(@Nullable Double value) {
            this.interval = value;
            return this;
        }

        public Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        public Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public Builder offset(@Nullable Double value) {
            this.offset = value;
            return this;
        }

        public Builder order(@Nullable HistogramOrder value) {
            this.order = value;
            return this;
        }

        public Builder order(Function<HistogramOrder.Builder, ObjectBuilder<HistogramOrder>> fn) {
            return this.order(fn.apply(new HistogramOrder.Builder()).build());
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HistogramAggregation build() {
            return new HistogramAggregation(this);
        }
    }
}

