/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HdrMethod
implements JsonpSerializable {
    @Nullable
    private final Integer numberOfSignificantValueDigits;
    public static final JsonpDeserializer<HdrMethod> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HdrMethod::setupHdrMethodDeserializer, Builder::build);

    public HdrMethod(Builder builder) {
        this.numberOfSignificantValueDigits = builder.numberOfSignificantValueDigits;
    }

    public HdrMethod(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer numberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numberOfSignificantValueDigits != null) {
            generator.writeKey("number_of_significant_value_digits");
            generator.write(this.numberOfSignificantValueDigits.intValue());
        }
    }

    protected static void setupHdrMethodDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::numberOfSignificantValueDigits, JsonpDeserializer.integerDeserializer(), "number_of_significant_value_digits", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HdrMethod> {
        @Nullable
        private Integer numberOfSignificantValueDigits;

        public Builder numberOfSignificantValueDigits(@Nullable Integer value) {
            this.numberOfSignificantValueDigits = value;
            return this;
        }

        @Override
        public HdrMethod build() {
            return new HdrMethod(this);
        }
    }
}

